/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.util;

import com.xinian.tickaccelerate.TickAccelerate;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.Nullable;

public class TPSCalculator {
    public Long lastTick;
    public Long currentTick;
    private double trueMissedTicks = 0.0;
    private double compensationTicks = 0.0;
    private final List<Double> tpsHistory = new CopyOnWriteArrayList<Double>();
    private static final int historyLimit = 40;
    public static final int MAX_TPS = 20;
    public static final int FULL_TICK = 50;
    private static final double SMOOTHING_FACTOR = 0.1;
    private double smoothedMSPT = 50.0;
    public static float tpsMultiplier = 1.0f;

    public TPSCalculator() {
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
    }

    private void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.currentTick != null) {
            this.lastTick = this.currentTick;
        }
        this.currentTick = System.currentTimeMillis();
        long currentMSPT = this.getMSPT();
        this.smoothedMSPT = (double)currentMSPT * 0.1 + this.smoothedMSPT * 0.9;
        this.addToHistory(this.getTPS());
        this.clearMissedTicks();
        this.missedTick();
        double mostAccurateTps = this.getMostAccurateTPS();
        tpsMultiplier = mostAccurateTps > 0.0 ? (float)(20.0 / mostAccurateTps) : 1.0f;
    }

    public int getEffectiveTickCap() {
        return this.getEffectiveTickCap(null);
    }

    public int getEffectiveTickCap(@Nullable ResourceLocation blockId) {
        int baseCap = blockId == null ? TickAccelerate.config.getTickRepeatCap() : TickAccelerate.config.getCapForBlock(blockId);
        if (baseCap < 0) {
            return -1;
        }
        if (!TickAccelerate.config.dynamicCapEnabled()) {
            return baseCap;
        }
        long currentMspt = this.getMSPT();
        int threshold = TickAccelerate.config.getDynamicCapMsptThreshold();
        if (threshold > 0 && currentMspt > (long)threshold) {
            return 0;
        }
        return baseCap;
    }

    private void addToHistory(double tps) {
        if (this.tpsHistory.size() >= 40) {
            this.tpsHistory.remove(0);
        }
        this.tpsHistory.add(tps);
    }

    public long getMSPT() {
        if (this.lastTick == null || this.currentTick == null) {
            return 0L;
        }
        return this.currentTick - this.lastTick;
    }

    public double getSmoothedMSPT() {
        return this.smoothedMSPT;
    }

    public double getAverageTPS() {
        return this.tpsHistory.stream().mapToDouble(Double::doubleValue).average().orElse(20.0);
    }

    public double getTPS() {
        if (this.smoothedMSPT <= 0.0) {
            return 20.0;
        }
        double tps = 1000.0 / this.smoothedMSPT;
        return Math.min(tps, 20.0);
    }

    public void missedTick() {
        double currentSmoothedMSPT = this.getSmoothedMSPT();
        if (currentSmoothedMSPT <= 0.0) {
            return;
        }
        double missed = currentSmoothedMSPT / 50.0 - 1.0;
        this.trueMissedTicks += Math.max(0.0, missed);
        if (TickAccelerate.config.extraCompensationEnabled() && currentSmoothedMSPT > (double)TickAccelerate.config.getExtraCompensationMsptThreshold()) {
            double compensationAmount = (double)TickAccelerate.config.getExtraCompensationAmountMs() / 50.0;
            this.compensationTicks += compensationAmount;
        }
    }

    public double getMostAccurateTPS() {
        return Math.min(this.getTPS(), this.getAverageTPS());
    }

    public double getAllMissedTicks() {
        return this.trueMissedTicks;
    }

    public int applicableMissedTicks() {
        return (int)Math.floor(this.trueMissedTicks + this.compensationTicks);
    }

    public void clearMissedTicks() {
        int ticksUsed = this.applicableMissedTicks();
        if (ticksUsed == 0) {
            return;
        }
        double totalTicks = this.trueMissedTicks + this.compensationTicks;
        if (totalTicks <= 0.0) {
            return;
        }
        double trueProportion = this.trueMissedTicks / totalTicks;
        this.trueMissedTicks -= (double)ticksUsed * trueProportion;
        this.compensationTicks -= (double)ticksUsed * (1.0 - trueProportion);
    }

    public void resetMissedTicks() {
        this.trueMissedTicks = 0.0;
        this.compensationTicks = 0.0;
    }
}

