/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.mixin.world;

import com.xinian.tickaccelerate.TickAccelerate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LevelChunk.BoundTickingBlockEntity.class})
public abstract class LevelChunk$BoundTickingBlockEntityMixin {
    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntityTicker;tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"))
    private <T extends BlockEntity> void onTick(BlockEntityTicker<T> instance, Level level, BlockPos blockPos, BlockState blockState, T t) {
        instance.m_155252_(level, blockPos, blockState, t);
        if (!TickAccelerate.config.enabled()) {
            return;
        }
        if (!TickAccelerate.config.blockEntityAcceleration()) {
            return;
        }
        if (level.m_5776_()) {
            return;
        }
        if (!TickAccelerate.blockEntityMaskConfig.getMask().isOkay(ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()))) {
            return;
        }
        int ticksToApply = TickAccelerate.TPS_CALCULATOR.applicableMissedTicks();
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
        int cap = TickAccelerate.TPS_CALCULATOR.getEffectiveTickCap(blockId);
        if (cap >= 0) {
            ticksToApply = Math.min(ticksToApply, cap);
        }
        for (int i = 0; i < ticksToApply; ++i) {
            instance.m_155252_(level, blockPos, blockState, t);
        }
    }
}

