/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class TOMLConfiguration {
    public final String fileName;
    protected final CommentedFileConfig config;

    public TOMLConfiguration(String fileName) {
        this.fileName = fileName;
        File file = new File(String.valueOf(FMLPaths.CONFIGDIR.get().toAbsolutePath()) + "/tickaccelerate/", fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.config = (CommentedFileConfig)CommentedFileConfig.builder((File)file).autosave().build();
    }

    public void save() {
        this.config.save();
    }

    public void reload() {
        this.config.load();
    }

    public <T> T get(String key) {
        return (T)this.config.get(key);
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        Object value = this.config.get(key);
        return (T)(value == null ? defaultValue : value);
    }

    public void set(String key, Object value) {
        this.config.set(key, value);
    }

    public void setComment(String key, String comment) {
        this.config.setComment(key, comment);
    }

    public void putIfEmpty(String key, Object value) {
        if (!this.config.contains(key)) {
            this.set(key, value);
        }
    }

    public CommentedConfig getRawConfig() {
        return this.config;
    }

    @Nullable
    public Double getCustomTpsMultiplier(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        String path = "custom_acceleration." + resourceLocation.toString() + ".tpsMultiplier";
        return (Double)this.config.get(path);
    }

    @Nullable
    public Integer getCustomTickCap(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        String path = "custom_acceleration." + resourceLocation.toString() + ".tickCap";
        return (Integer)this.config.get(path);
    }
}

