/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.xinian.tickaccelerate.TickAccelerate;
import com.xinian.tickaccelerate.config.MainConfig;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ToggleCommand {
    public static CompletableFuture<Suggestions> suggestConfigKeys(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        MainConfig.getBooleanOptions().stream().map(option -> option.getKey()).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static int executeToggle(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String key = StringArgumentType.getString(context, (String)"key");
        if (MainConfig.getBooleanOptions().stream().noneMatch(o -> o.getKey().equals(key))) {
            source.m_81352_((Component)Component.m_237110_((String)"tickaccelerate.command.toggle.unknown_key", (Object[])new Object[]{key}));
            return 0;
        }
        boolean currentValue = TickAccelerate.config.getBoolean(key);
        boolean newValue = !currentValue;
        TickAccelerate.config.setBoolean(key, newValue);
        TickAccelerate.config.save();
        MutableComponent enabledText = Component.m_237115_((String)(newValue ? "tickaccelerate.status.enabled" : "tickaccelerate.status.disabled"));
        source.m_243053_((Component)Component.m_237110_((String)"tickaccelerate.command.toggle.feedback", (Object[])new Object[]{key, enabledText}));
        return 1;
    }
}

