/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.utils;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.IStagesData;
import com.decursioteam.decursio_stages.events.UpdateStageEvent;
import com.decursioteam.decursio_stages.network.messages.SyncStagesMessage;
import com.decursioteam.decursio_stages.utils.StagesHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class StageUtil {
    public static boolean hasStage(Player player, String stage) {
        return StageUtil.hasStage(player, StageUtil.getPlayerData(player), stage);
    }

    public static boolean hasStage(Player player, @Nullable IStagesData data, String stage) {
        if (data != null) {
            UpdateStageEvent.Check event = new UpdateStageEvent.Check(player, stage, data.hasStage(stage));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.hasStage();
        }
        return false;
    }

    public static boolean hasAnyOf(Player player, String ... stages) {
        return StageUtil.hasAnyOf(player, StageUtil.getPlayerData(player), stages);
    }

    public static boolean hasAnyOf(Player player, Collection<String> stages) {
        return StageUtil.hasAnyOf(player, StageUtil.getPlayerData(player), stages);
    }

    public static boolean hasAnyOf(Player player, @Nullable IStagesData data, Collection<String> stages) {
        return stages.stream().anyMatch(stage -> StageUtil.hasStage(player, data, stage.toLowerCase(Locale.ROOT)));
    }

    public static boolean hasAnyOf(Player player, @Nullable IStagesData data, String ... stages) {
        return Arrays.stream(stages).anyMatch(stage -> StageUtil.hasStage(player, data, stage.toLowerCase(Locale.ROOT)));
    }

    public static boolean hasAllOf(Player player, String ... stages) {
        return StageUtil.hasAllOf(player, StageUtil.getPlayerData(player), stages);
    }

    public static boolean hasAllOf(Player player, Collection<String> stages) {
        return StageUtil.hasAllOf(player, StageUtil.getPlayerData(player), stages);
    }

    public static boolean hasAllOf(Player player, @Nullable IStagesData data, Collection<String> stages) {
        return stages.stream().allMatch(stage -> StageUtil.hasStage(player, data, stage.toLowerCase(Locale.ROOT)));
    }

    public static boolean hasAllOf(Player player, @Nullable IStagesData data, String ... stages) {
        return Arrays.stream(stages).allMatch(stage -> StageUtil.hasStage(player, data, stage.toLowerCase(Locale.ROOT)));
    }

    public static void addStage(ServerPlayer player, String stage) {
        IStagesData data;
        if (!MinecraftForge.EVENT_BUS.post((Event)new UpdateStageEvent.Add((Player)player, stage.toLowerCase(Locale.ROOT))) && (data = StageUtil.getPlayerData((Player)player)) != null) {
            data.addStage(stage);
            StageUtil.syncPlayer(player);
            MinecraftForge.EVENT_BUS.post((Event)new UpdateStageEvent.Added((Player)player, stage.toLowerCase(Locale.ROOT)));
        }
    }

    public static void removeStage(ServerPlayer player, String stage) {
        IStagesData data;
        if (!MinecraftForge.EVENT_BUS.post((Event)new UpdateStageEvent.Remove((Player)player, stage.toLowerCase(Locale.ROOT))) && (data = StageUtil.getPlayerData((Player)player)) != null) {
            data.removeStage(stage);
            StageUtil.syncPlayer(player);
            MinecraftForge.EVENT_BUS.post((Event)new UpdateStageEvent.Removed((Player)player, stage.toLowerCase(Locale.ROOT)));
        }
    }

    public static int clearStages(ServerPlayer player) {
        IStagesData stageInfo = StageUtil.getPlayerData((Player)player);
        if (stageInfo != null) {
            int stageCount = stageInfo.getStages().size();
            stageInfo.clear();
            StageUtil.syncPlayer(player);
            MinecraftForge.EVENT_BUS.post((Event)new UpdateStageEvent.Cleared((Player)player, stageInfo));
            return stageCount;
        }
        return 0;
    }

    @Nullable
    public static IStagesData getPlayerData(Player player) {
        if (player != null) {
            if (player instanceof ServerPlayer) {
                return StagesHandler.getPlayerData(player.m_20148_());
            }
            if (EffectiveSide.get().isClient()) {
                return StagesHandler.getClientData();
            }
        }
        return null;
    }

    public static void syncPlayer(ServerPlayer player) {
        IStagesData info = StageUtil.getPlayerData((Player)player);
        if (info != null) {
            DecursioStages.LOGGER.info("Syncing {} stages for {}.", (Object)info.getStages().size(), (Object)player.m_7755_().getString());
            DecursioStages.NETWORK.sendToPlayer(player, new SyncStagesMessage(info.getStages()));
        }
    }

    public static Set<String> getStages() {
        HashSet<String> stages = new HashSet<String>();
        RestrictionsData.getRegistry().getRawRestrictions().forEach((name, rawJSON) -> stages.add(rawJSON.getAsJsonObject("Restriction Data").get("stage").getAsString()));
        return stages;
    }
}

