/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.utils;

import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.restrictions.DimensionRestriction;
import com.decursioteam.decursio_stages.restrictions.FluidRestriction;
import com.decursioteam.decursio_stages.restrictions.ItemExclusion;
import com.decursioteam.decursio_stages.restrictions.ItemRestriction;
import com.decursioteam.decursio_stages.utils.NBTComparisonUtil;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ResourceUtil {
    public static Set<ItemRestriction> getItems(String restriction) {
        return new HashSet<ItemRestriction>(RestrictionsData.getRestrictionData(restriction).getData().getItemList());
    }

    public static Set<ResourceLocation> getTags(String restriction) {
        return new HashSet<ResourceLocation>(RestrictionsData.getRestrictionData(restriction).getData().getTagList());
    }

    public static Set<String> getMods(String restriction) {
        return new HashSet<String>(RestrictionsData.getRestrictionData(restriction).getData().getModList());
    }

    public static HashSet<FluidRestriction> getFluids(String restriction) {
        return new HashSet<FluidRestriction>(RestrictionsData.getRestrictionData(restriction).getData().getFluidList());
    }

    public static Set<ItemExclusion> getExceptions(String restriction) {
        return new HashSet<ItemExclusion>(RestrictionsData.getRestrictionData(restriction).getData().getExceptionList());
    }

    public static Set<DimensionRestriction> getDimensions(String restriction) {
        return new HashSet<DimensionRestriction>(RestrictionsData.getRestrictionData(restriction).getData().getDimensionList());
    }

    public static Set<String> getContainers(String restriction) {
        return new HashSet<String>(RestrictionsData.getRestrictionData(restriction).getData().getContainerList());
    }

    public static boolean getApplyToFakePlayer(String restriction) {
        return RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getApplyToFakePlayers();
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static boolean check(String restriction, ItemStack itemStack, CHECK_TYPES checkType) {
        if (ResourceUtil.getRegistryName(itemStack.m_41720_()).equals((Object)new ResourceLocation("minecraft:air"))) {
            return false;
        }
        if (!ResourceUtil.isItemExcluded(restriction, itemStack)) {
            return false;
        }
        switch (checkType) {
            case ITEM: {
                for (ItemRestriction item : ResourceUtil.getItems(restriction)) {
                    if (!NBTComparisonUtil.doesItemMatchRestriction(item, itemStack)) continue;
                    return true;
                }
                return false;
            }
            case MOD: {
                if (!ResourceUtil.getMods(restriction).isEmpty()) {
                    String itemMod = Objects.requireNonNull(ResourceUtil.getRegistryName(itemStack.m_41720_())).m_135827_();
                    return ResourceUtil.getMods(restriction).contains(itemMod);
                }
                return false;
            }
            case TAG: {
                if (!ResourceUtil.getTags(restriction).isEmpty()) {
                    for (ResourceLocation tagID : ResourceUtil.getTags(restriction)) {
                        if (!itemStack.m_204117_(Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(tagID))) continue;
                        return true;
                    }
                }
                return false;
            }
            case ALL: {
                return ResourceUtil.check(restriction, itemStack, CHECK_TYPES.ITEM) || ResourceUtil.check(restriction, itemStack, CHECK_TYPES.MOD) || ResourceUtil.check(restriction, itemStack, CHECK_TYPES.TAG);
            }
        }
        return false;
    }

    public static boolean isItemExcluded(String restriction, ItemStack itemStack) {
        AtomicBoolean isExcluded = new AtomicBoolean(false);
        ResourceUtil.getExceptions(restriction).forEach(itemExclusion -> {
            if (itemExclusion.getResourceLocation() != null) {
                if (itemExclusion.getCompoundNBT() == null) {
                    if (itemExclusion.getItemStack().m_150930_(itemStack.m_41720_())) {
                        isExcluded.set(true);
                    }
                } else if (itemStack.m_41783_() != null && itemExclusion.getItemStack().m_150930_(itemStack.m_41720_()) && NBTComparisonUtil.areNBTCompoundsEqual(itemExclusion.getCompoundNBT(), itemStack.m_41783_())) {
                    isExcluded.set(true);
                }
            } else if (itemExclusion.getMod() != null) {
                if (ResourceUtil.getRegistryName(itemStack.m_41720_()).m_135827_().equals(itemExclusion.getMod())) {
                    isExcluded.set(true);
                }
            } else if (itemExclusion.getTag() != null && itemStack.m_204117_(Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createTagKey(itemExclusion.getTag()))) {
                isExcluded.set(true);
            }
        });
        return !isExcluded.get();
    }

    public static JsonObject itemStackToJson(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ResourceUtil.getRegistryName(stack.m_41720_()).toString());
        if (stack.m_41782_()) {
            json.add("nbt", NBTComparisonUtil.nbtToJson(stack.m_41783_()));
        }
        return json;
    }

    public static ItemStack jsonToItemStack(JsonObject json) {
        CompoundTag nbt;
        if (!json.has("item")) {
            return ItemStack.f_41583_;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("item").getAsString()));
        if (item == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (json.has("nbt") && (nbt = NBTComparisonUtil.jsonToNbt(json.get("nbt"))) != null) {
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public static ItemRestriction createWildcardRestriction(ItemStack base, String nbtPath) {
        if (base.m_41619_()) {
            return null;
        }
        if (!base.m_41782_() || "*".equals(nbtPath)) {
            return new ItemRestriction(ResourceUtil.getRegistryName(base.m_41720_()), null);
        }
        CompoundTag nbtCopy = base.m_41783_().m_6426_();
        if (!"*".equals(nbtPath)) {
            nbtCopy = NBTComparisonUtil.createNbtWithWildcard(nbtCopy, nbtPath);
        }
        return new ItemRestriction(ResourceUtil.getRegistryName(base.m_41720_()), Optional.ofNullable(nbtCopy));
    }

    public static enum CHECK_TYPES {
        MOD,
        ITEM,
        TAG,
        ALL;

    }
}

