/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.restrictions;

import com.decursioteam.decursio_stages.DecursioStages;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemExclusion {
    private ResourceLocation item;
    private CompoundTag compoundTag;
    private String mod;
    private ResourceLocation tag;

    public ItemExclusion(Optional<ResourceLocation> item, Optional<CompoundTag> compoundTag, Optional<ResourceLocation> tag, Optional<String> mod) {
        try {
            item.ifPresent(x -> {
                this.item = (ResourceLocation)item.get();
            });
            tag.ifPresent(x -> {
                this.tag = (ResourceLocation)tag.get();
            });
            mod.ifPresent(x -> {
                this.mod = (String)mod.get();
            });
            compoundTag.ifPresent(x -> {
                this.compoundTag = (CompoundTag)compoundTag.get();
            });
        }
        catch (NullPointerException e) {
            DecursioStages.LOGGER.error("Error creating FluidRestriction: {}", (Object)e.getMessage());
        }
    }

    public static Codec<ItemExclusion> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("item").orElse(null).forGetter(itemExclusion -> Optional.ofNullable(itemExclusion.item)), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").orElse(null).forGetter(itemExclusion -> Optional.ofNullable(itemExclusion.compoundTag)), (App)ResourceLocation.f_135803_.optionalFieldOf("tag").orElse(null).forGetter(itemExclusion -> Optional.ofNullable(itemExclusion.tag)), (App)Codec.STRING.optionalFieldOf("mod").orElse(null).forGetter(itemExclusion -> Optional.ofNullable(itemExclusion.mod))).apply((Applicative)instance, ItemExclusion::new));
    }

    @Nullable
    public CompoundTag getCompoundNBT() {
        return this.compoundTag;
    }

    @Nullable
    public String getMod() {
        return this.mod;
    }

    @Nullable
    public ResourceLocation getTag() {
        return this.tag;
    }

    @Nullable
    public ResourceLocation getResourceLocation() {
        return this.item;
    }

    @Nullable
    public Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.item);
    }

    @Nullable
    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)this.getItem());
        if (this.getCompoundNBT() != null) {
            itemStack.m_41751_(this.getCompoundNBT());
        }
        return itemStack;
    }
}

