/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.restrictions;

import com.decursioteam.decursio_stages.DecursioStages;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidRestriction {
    private ResourceLocation fluid;
    private String mod;
    private ResourceLocation tag;

    public FluidRestriction(Optional<ResourceLocation> fluid, Optional<ResourceLocation> tag, Optional<String> mod) {
        try {
            fluid.ifPresent(x -> {
                this.fluid = (ResourceLocation)fluid.get();
            });
            tag.ifPresent(x -> {
                this.tag = (ResourceLocation)tag.get();
            });
            mod.ifPresent(x -> {
                this.mod = (String)mod.get();
            });
        }
        catch (NullPointerException e) {
            DecursioStages.LOGGER.error("Error creating FluidRestriction: {}", (Object)e.getMessage());
        }
    }

    public static Codec<FluidRestriction> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("fluid").orElse(null).forGetter(itemExclusion -> Optional.ofNullable(itemExclusion.fluid)), (App)ResourceLocation.f_135803_.optionalFieldOf("tag").orElse(null).forGetter(itemExclusion -> Optional.ofNullable(itemExclusion.tag)), (App)Codec.STRING.optionalFieldOf("mod").orElse(null).forGetter(itemExclusion -> Optional.ofNullable(itemExclusion.mod))).apply((Applicative)instance, FluidRestriction::new));
    }

    @Nullable
    public String getMod() {
        return this.mod;
    }

    @Nullable
    public ResourceLocation getTag() {
        return this.tag;
    }

    @Nullable
    public ResourceLocation getResourceLocation() {
        return this.fluid;
    }

    @Nullable
    public Fluid getFluid() {
        if (this.fluid == null) {
            return null;
        }
        return (Fluid)ForgeRegistries.FLUIDS.getValue(this.fluid);
    }
}

