/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.network;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.client.screens.RestrictMenu;
import com.decursioteam.decursio_stages.client.screens.RestrictScreen;
import com.decursioteam.decursio_stages.datagen.utils.FileUtils;
import com.decursioteam.decursio_stages.network.messages.OpenRestrictScreenMessage;
import com.decursioteam.decursio_stages.network.messages.SaveRestrictionMessage;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MessageHandlers {
    public static void handleOpenRestrictScreen(OpenRestrictScreenMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> context.enqueueWork(() -> MessageHandlers.openRestrictScreenClient(message)));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openRestrictScreenClient(OpenRestrictScreenMessage message) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            try {
                RestrictMenu menu = new RestrictMenu(message.getWindowId(), minecraft.f_91074_.m_150109_());
                minecraft.f_91074_.f_36096_ = menu;
                RestrictScreen screen = new RestrictScreen(menu, minecraft.f_91074_.m_150109_(), (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.items_to_restrict"));
                minecraft.m_91152_((Screen)screen);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleSaveRestriction(SaveRestrictionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || !player.m_20310_(2)) {
                return;
            }
            try {
                ItemStack itemStack = message.getItemStack();
                if (!itemStack.m_41619_()) {
                    boolean success = FileUtils.restrictItem(message.getStage(), message.getAdvancedTooltips(), message.getItemTitle(), message.getPickupDelay(), message.isHideInJEI(), message.isCanPickup(), message.isContainerListWhitelist(), message.isCheckPlayerInventory(), message.isCheckPlayerEquipment(), message.isUsableItems(), message.isUsableBlocks(), message.isDestroyableBlocks(), itemStack);
                    if (success) {
                        DecursioStages.LOGGER.info("Successfully restricted item {} for stage {}", (Object)itemStack.m_41720_().toString(), (Object)message.getStage());
                        Registry.setupRestrictions();
                        Registry.registerRestrictionsList();
                        player.m_213846_((Component)Component.m_237110_((String)"decursio_stages.commands.restrictitem.success", (Object[])new Object[]{Component.m_237113_((String)itemStack.m_41720_().toString()).m_130940_(ChatFormatting.AQUA), Component.m_237113_((String)message.getStage()).m_130940_(ChatFormatting.DARK_PURPLE)}));
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"decursio_stages.commands.restrictitem.failure").m_130940_(ChatFormatting.RED));
                    }
                }
            }
            catch (Exception e) {
                player.m_213846_((Component)Component.m_237113_((String)("Error creating restriction: " + e.getMessage())).m_130940_(ChatFormatting.RED));
                DecursioStages.LOGGER.error("MessageHandlers: Error processing restriction", (Throwable)e);
            }
        });
        context.setPacketHandled(true);
    }
}

