/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.network;

import com.decursioteam.decursio_stages.datagen.StagesData;
import com.decursioteam.decursio_stages.events.SyncStagesEvent;
import com.decursioteam.decursio_stages.network.messages.OpenRestrictScreenMessage;
import com.decursioteam.decursio_stages.network.messages.SaveRestrictionMessage;
import com.decursioteam.decursio_stages.network.messages.SyncStagesMessage;
import com.decursioteam.decursio_stages.utils.StagesHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandler {
    public static SyncStagesMessage decodeStageMessage(FriendlyByteBuf buffer) {
        String[] stageNames = new String[buffer.readInt()];
        for (int i = 0; i < stageNames.length; ++i) {
            stageNames[i] = buffer.m_130136_(64);
        }
        return new SyncStagesMessage(stageNames);
    }

    public static OpenRestrictScreenMessage decodeOpenRestrictScreenMessage(FriendlyByteBuf buffer) {
        return new OpenRestrictScreenMessage(buffer);
    }

    public static SaveRestrictionMessage decodeSaveRestrictionMessage(FriendlyByteBuf buffer) {
        return new SaveRestrictionMessage(buffer);
    }

    public static void processSyncStagesMessage(SyncStagesMessage message, Supplier<NetworkEvent.Context> context) {
        StagesData clientData = new StagesData();
        for (String stageName : message.getStages()) {
            clientData.addStage(stageName);
        }
        StagesHandler.setClientData(clientData);
        MinecraftForge.EVENT_BUS.post((Event)new SyncStagesEvent(clientData));
    }
}

