/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.mobstaging;

import com.decursioteam.decursio_stages.mobstaging.EffectsCodec;
import com.decursioteam.decursio_stages.mobstaging.LoadoutRestriction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobSpawnType;

public class MobRestriction {
    private final Optional<ResourceLocation> entityID;
    private final Optional<String> entityModID;
    private final Optional<String> mobCategory;
    private final Optional<ResourceLocation> entityTag;
    private final Optional<Integer> minLight;
    private final Optional<Integer> maxLight;
    private final Optional<List<ResourceLocation>> biomes;
    private final String listType;
    private final List<String> spawnType;
    private final Optional<Integer> health;
    private final Optional<List<EffectsCodec>> effects;
    private final Optional<List<LoadoutRestriction>> loadoutList;

    public MobRestriction(List<String> spawnType, String listType, Optional<ResourceLocation> entityID, Optional<String> entityModID, Optional<String> mobCategory, Optional<ResourceLocation> entityTag, Optional<Integer> minLight, Optional<Integer> maxLight, Optional<List<ResourceLocation>> biomes, Optional<Integer> health, Optional<List<EffectsCodec>> effects, Optional<List<LoadoutRestriction>> loadoutList) {
        this.spawnType = spawnType;
        this.listType = listType;
        this.entityModID = entityModID;
        this.entityID = entityID;
        this.mobCategory = mobCategory;
        this.entityTag = entityTag;
        this.minLight = minLight;
        this.maxLight = maxLight;
        this.biomes = biomes;
        this.health = health;
        this.effects = effects;
        this.loadoutList = loadoutList;
    }

    public static Codec<MobRestriction> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("spawnType").forGetter(MobRestriction::getSpawnTypeString), (App)Codec.STRING.fieldOf("whitelist_blacklist").forGetter(MobRestriction::getListType), (App)ResourceLocation.f_135803_.optionalFieldOf("entityID").forGetter(MobRestriction::getEntityID), (App)Codec.STRING.optionalFieldOf("entityModID").forGetter(MobRestriction::getEntityModID), (App)Codec.STRING.optionalFieldOf("mobCategory").forGetter(MobRestriction::getMobCategory), (App)ResourceLocation.f_135803_.optionalFieldOf("entityTag").forGetter(MobRestriction::getEntityTag), (App)Codec.INT.optionalFieldOf("minLight").forGetter(MobRestriction::getMinLight), (App)Codec.INT.optionalFieldOf("maxLight").forGetter(MobRestriction::getMaxLight), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("biomes").forGetter(MobRestriction::getBiomes), (App)Codec.INT.optionalFieldOf("health").forGetter(MobRestriction::getHealth), (App)EffectsCodec.codec().listOf().optionalFieldOf("effects").forGetter(MobRestriction::getEffects), (App)LoadoutRestriction.codec().listOf().optionalFieldOf("loadout").orElse(null).forGetter(MobRestriction::getLoadoutList)).apply((Applicative)instance, (spawnType1, listType1, entityID1, entityModID1, mobCategory1, entityTag1, minlight1, maxlight1, biomes1, health1, effects1, loadoutList1) -> new MobRestriction((List<String>)spawnType1, (String)listType1, (Optional<ResourceLocation>)entityID1, (Optional<String>)entityModID1, (Optional<String>)mobCategory1, (Optional<ResourceLocation>)entityTag1, (Optional<Integer>)minlight1, (Optional<Integer>)maxlight1, (Optional<List<ResourceLocation>>)biomes1, (Optional<Integer>)health1, (Optional<List<EffectsCodec>>)effects1, (Optional<List<LoadoutRestriction>>)loadoutList1)));
    }

    public Optional<Integer> getHealth() {
        return this.health;
    }

    public List<String> getSpawnTypeString() {
        return this.spawnType;
    }

    public List<MobSpawnType> getSpawnType() {
        ArrayList<MobSpawnType> list = new ArrayList<MobSpawnType>();
        for (String s : this.spawnType) {
            list.add(MobSpawnType.valueOf((String)s));
        }
        return list;
    }

    public String getListType() {
        return this.listType;
    }

    public Optional<String> getEntityModID() {
        return this.entityModID;
    }

    public Optional<Integer> getMaxLight() {
        return this.maxLight;
    }

    public Optional<Integer> getMinLight() {
        return this.minLight;
    }

    public Optional<List<EffectsCodec>> getEffects() {
        return this.effects;
    }

    public Optional<List<ResourceLocation>> getBiomes() {
        return this.biomes;
    }

    public Optional<ResourceLocation> getEntityTag() {
        return this.entityTag;
    }

    public Optional<ResourceLocation> getEntityID() {
        return this.entityID;
    }

    public Optional<String> getMobCategory() {
        return this.mobCategory;
    }

    public Optional<List<LoadoutRestriction>> getLoadoutList() {
        return this.loadoutList;
    }
}

