/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.mobstaging;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class LoadoutRestriction {
    private final ResourceLocation item;
    private String slot;
    private CompoundTag compoundTag;
    private final Integer chance;

    public LoadoutRestriction(ResourceLocation item, String slot, Optional<CompoundTag> compoundTag, Integer chance) {
        this.item = item;
        this.chance = chance;
        this.slot = slot;
        compoundTag.ifPresent(x -> {
            this.compoundTag = (CompoundTag)compoundTag.get();
        });
    }

    public static Codec<LoadoutRestriction> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("item").orElse((Object)new ResourceLocation("")).forGetter(LoadoutRestriction::getResourceLocation), (App)Codec.STRING.fieldOf("slot").orElse((Object)"").forGetter(LoadoutRestriction::getSlot), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").orElse(null).forGetter(itemRestriction -> Optional.ofNullable(itemRestriction.compoundTag)), (App)Codec.INT.fieldOf("chance").orElse((Object)100).forGetter(LoadoutRestriction::getChance)).apply((Applicative)instance, LoadoutRestriction::new));
    }

    public Integer getChance() {
        return Math.min(100, this.chance);
    }

    @Nullable
    public CompoundTag getCompoundNBT() {
        return this.compoundTag;
    }

    public String getSlot() {
        return this.slot;
    }

    public ResourceLocation getResourceLocation() {
        return this.item;
    }

    public Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.item);
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack((ItemLike)this.getItem());
        if (this.getCompoundNBT() != null) {
            itemStack.m_41751_(this.getCompoundNBT());
        }
        return itemStack;
    }
}

