/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.mobstaging;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;

public class EffectsCodec {
    private final ResourceLocation effect;
    private final Integer amplifier;
    private final Integer duration;
    private final Integer chance;

    public EffectsCodec(ResourceLocation effect, Integer amplifier, Integer duration, Integer chance) {
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.chance = chance;
    }

    public static Codec<EffectsCodec> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("effect").orElse((Object)new ResourceLocation("")).forGetter(EffectsCodec::getResourceLocation), (App)Codec.INT.fieldOf("amplifier").orElse((Object)1).forGetter(EffectsCodec::getAmplifier), (App)Codec.INT.fieldOf("duration").orElse((Object)100).forGetter(EffectsCodec::getDuration), (App)Codec.INT.fieldOf("chance").orElse((Object)100).forGetter(EffectsCodec::getChance)).apply((Applicative)instance, EffectsCodec::new));
    }

    public Integer getChance() {
        return Math.min(100, this.chance);
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Integer getAmplifier() {
        return this.amplifier;
    }

    public ResourceLocation getResourceLocation() {
        return this.effect;
    }
}

