/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.events;

import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.mobstaging.EffectsCodec;
import com.decursioteam.decursio_stages.mobstaging.MobRestriction;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;

public class MobEvents {
    private final Random random = new Random();

    @SubscribeEvent
    public void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        var ref = new Object(){
            Player closestPlayer = null;
        };
        for (ServerPlayer player : Objects.requireNonNull(event.getLevel().m_7654_()).m_6846_().m_11314_()) {
            if (ref.closestPlayer != null && !(player.m_20270_((Entity)event.getEntity()) < ref.closestPlayer.m_20270_((Entity)event.getEntity()))) continue;
            ref.closestPlayer = player;
        }
        if (ref.closestPlayer == null) {
            return;
        }
        ResourceLocation entityID = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
        String entityCategory = event.getEntity().m_6095_().m_20674_().m_21607_();
        AtomicBoolean shouldSpawn = new AtomicBoolean(true);
        Registry.getRestrictions().forEach(restriction -> {
            if (!ResourceUtil.getApplyToFakePlayer(restriction) && ref.closestPlayer instanceof FakePlayer) {
                return;
            }
            String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
            List<MobRestriction> mobList = RestrictionsData.getRestrictionData(restriction).getData().getMobList();
            if (StageUtil.hasStage(ref.closestPlayer, stage)) {
                for (MobRestriction e : mobList) {
                    MobEffect mobEffect;
                    int amplifier;
                    int duration;
                    ResourceLocation effectLocation;
                    boolean biomeMatch;
                    int lightLevel;
                    boolean matchesEntityTag;
                    boolean matchesEntityID = e.getEntityID().isPresent() && e.getEntityID().get().equals((Object)entityID);
                    boolean matchesModID = e.getEntityModID().isPresent() && e.getEntityModID().get().equals(entityID.m_135827_());
                    boolean matchesMobCategory = e.getMobCategory().isPresent() && e.getMobCategory().get().equals(entityCategory);
                    boolean bl = matchesEntityTag = e.getEntityTag().isPresent() && ForgeRegistries.ENTITY_TYPES.tags().getReverseTag((Object)event.getEntity().m_6095_()).isPresent() && ((IReverseTag)ForgeRegistries.ENTITY_TYPES.tags().getReverseTag((Object)event.getEntity().m_6095_()).get()).containsTag(ForgeRegistries.ENTITY_TYPES.tags().createTagKey(e.getEntityTag().get()));
                    if (!matchesEntityID && !matchesMobCategory && !matchesEntityTag && !matchesModID) continue;
                    if (e.getListType().equals("WHITELIST")) {
                        if (!e.getSpawnType().contains(event.getSpawnType())) {
                            shouldSpawn.set(false);
                        }
                        lightLevel = event.getLevel().m_7146_(event.getEntity().m_20183_());
                        if (e.getMaxLight().isPresent() && e.getMaxLight().get() <= lightLevel) {
                            shouldSpawn.set(false);
                        }
                        if (e.getMinLight().isPresent() && e.getMinLight().get() >= lightLevel) {
                            shouldSpawn.set(false);
                        }
                        if (e.getBiomes().isPresent() && !(biomeMatch = e.getBiomes().get().stream().anyMatch(resourceLocation -> event.getEntity().m_9236_().m_204166_(event.getEntity().m_20183_()).m_203373_(resourceLocation)))) {
                            shouldSpawn.set(false);
                        }
                        e.getHealth().ifPresent(health -> {
                            float prevMaxHealth = event.getEntity().m_21233_();
                            Objects.requireNonNull(event.getEntity().m_21051_(Attributes.f_22276_)).m_22125_(new AttributeModifier("Max Health Modifier", (double)((float)health.intValue() - prevMaxHealth), AttributeModifier.Operation.ADDITION));
                            event.getEntity().m_21153_((float)health.intValue());
                        });
                        if (e.getEffects().isPresent()) {
                            event.setCanceled(true);
                            for (EffectsCodec effect : e.getEffects().get()) {
                                if (this.random.nextInt(100) >= effect.getChance()) continue;
                                effectLocation = effect.getResourceLocation();
                                duration = effect.getDuration();
                                if (effect.getDuration() == 0) {
                                    duration = Integer.MAX_VALUE;
                                }
                                amplifier = effect.getAmplifier();
                                mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation);
                                if (mobEffect == null) continue;
                                event.getEntity().m_7292_(new MobEffectInstance(mobEffect, duration, amplifier));
                            }
                        }
                        if (e.getLoadoutList().isPresent()) {
                            event.setCanceled(true);
                            e.getLoadoutList().get().forEach(item -> {
                                if (this.random.nextInt(100) < item.getChance()) {
                                    switch (item.getSlot().toUpperCase(Locale.ROOT)) {
                                        case "MAINHAND": {
                                            event.getEntity().m_21008_(InteractionHand.MAIN_HAND, item.getItemStack());
                                            break;
                                        }
                                        case "OFFHAND": {
                                            event.getEntity().m_21008_(InteractionHand.OFF_HAND, item.getItemStack());
                                            break;
                                        }
                                        case "FEET": {
                                            event.getEntity().m_8061_(EquipmentSlot.FEET, item.getItemStack());
                                            break;
                                        }
                                        case "LEGS": {
                                            event.getEntity().m_8061_(EquipmentSlot.LEGS, item.getItemStack());
                                            break;
                                        }
                                        case "CHEST": {
                                            event.getEntity().m_8061_(EquipmentSlot.CHEST, item.getItemStack());
                                            break;
                                        }
                                        case "HEAD": {
                                            event.getEntity().m_8061_(EquipmentSlot.HEAD, item.getItemStack());
                                        }
                                    }
                                }
                            });
                        }
                    }
                    if (!e.getListType().equals("BLACKLIST")) continue;
                    if (e.getSpawnType().contains(event.getSpawnType())) {
                        shouldSpawn.set(false);
                    }
                    lightLevel = event.getLevel().m_7146_(event.getEntity().m_20183_());
                    if (e.getMaxLight().isPresent() && e.getMaxLight().get() <= lightLevel) {
                        shouldSpawn.set(false);
                    }
                    if (e.getMinLight().isPresent() && e.getMinLight().get() >= lightLevel) {
                        shouldSpawn.set(false);
                    }
                    if (e.getBiomes().isPresent() && !(biomeMatch = e.getBiomes().get().stream().anyMatch(resourceLocation -> event.getEntity().m_9236_().m_204166_(event.getEntity().m_20183_()).m_203373_(resourceLocation)))) {
                        shouldSpawn.set(true);
                    }
                    if (e.getHealth().isPresent() && event.getEntity().m_21233_() == e.getHealth().get().floatValue()) {
                        shouldSpawn.set(false);
                    }
                    if (e.getEffects().isPresent()) {
                        for (EffectsCodec effect : e.getEffects().get()) {
                            effectLocation = effect.getResourceLocation();
                            duration = effect.getDuration() == 0 ? Integer.MAX_VALUE : effect.getDuration();
                            amplifier = effect.getAmplifier();
                            mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation);
                            if (mobEffect == null || !event.getEntity().m_21220_().stream().anyMatch(effectz -> effectz.equals((Object)new MobEffectInstance(mobEffect, duration, amplifier)))) continue;
                            shouldSpawn.set(false);
                        }
                    }
                    if (!e.getLoadoutList().isPresent()) continue;
                    e.getLoadoutList().get().forEach(item -> {
                        if (this.random.nextInt(100) < item.getChance()) {
                            switch (item.getSlot().toUpperCase(Locale.ROOT)) {
                                case "MAINHAND": {
                                    if (event.getEntity().m_6844_(EquipmentSlot.MAINHAND).m_150930_(item.getItem())) break;
                                    shouldSpawn.set(false);
                                    break;
                                }
                                case "OFFHAND": {
                                    if (event.getEntity().m_6844_(EquipmentSlot.OFFHAND).m_150930_(item.getItem())) break;
                                    shouldSpawn.set(false);
                                    break;
                                }
                                case "FEET": {
                                    if (event.getEntity().m_6844_(EquipmentSlot.FEET).m_150930_(item.getItem())) break;
                                    shouldSpawn.set(false);
                                    break;
                                }
                                case "LEGS": {
                                    if (event.getEntity().m_6844_(EquipmentSlot.LEGS).m_150930_(item.getItem())) break;
                                    shouldSpawn.set(false);
                                    break;
                                }
                                case "CHEST": {
                                    if (event.getEntity().m_6844_(EquipmentSlot.CHEST).m_150930_(item.getItem())) break;
                                    shouldSpawn.set(false);
                                    break;
                                }
                                case "HEAD": {
                                    if (event.getEntity().m_6844_(EquipmentSlot.HEAD).m_150930_(item.getItem())) break;
                                    shouldSpawn.set(false);
                                }
                            }
                        }
                    });
                }
            }
        });
        if (!shouldSpawn.get()) {
            this.cancelSpawn(event);
        }
    }

    private void cancelSpawn(MobSpawnEvent.FinalizeSpawn event) {
        event.setSpawnCancelled(true);
        event.setResult(Event.Result.DENY);
        event.setCanceled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onDebugOverlay(CustomizeGuiOverlayEvent.DebugText event) {
        LocalPlayer player;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_ && (player = mc.f_91074_) != null) {
            EntityHitResult entityHitResult;
            Entity target;
            HitResult hitResult = mc.f_91077_;
            if (hitResult == null) {
                hitResult = player.m_19907_(20.0, 0.0f, false);
            }
            if (hitResult.m_6662_() == HitResult.Type.ENTITY && (target = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                event.getRight().add("Category: " + livingTarget.m_6095_().m_20674_().m_21607_());
            }
        }
    }
}

