/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.events;

import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.config.CommonConfig;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import com.decursioteam.decursio_stages.utils.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ContainerEvents {
    private Set<ItemStack> prevInventory;

    @SubscribeEvent
    public void playerContainerOpenEvent(PlayerContainerEvent.Open event) {
        Player player;
        String containerName = event.getContainer().getClass().getName();
        if (Boolean.TRUE.equals(CommonConfig.debugMode.get())) {
            event.getEntity().m_5661_((Component)Component.m_237113_((String)containerName), false);
        }
        if ((player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Registry.getRestrictions().forEach(restriction -> {
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player2 instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (!StageUtil.hasStage((Player)player2, stage)) {
                    if (!RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getContainerListWhitelist() && ResourceUtil.getContainers(restriction).contains(containerName)) {
                        for (ItemStack item : event.getEntity().f_36095_.m_38927_()) {
                            if (!ResourceUtil.check(restriction, item, ResourceUtil.CHECK_TYPES.ALL)) continue;
                            Utils.dropItemStack((Player)player2, item);
                        }
                    }
                    if (RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getContainerListWhitelist() && !ResourceUtil.getContainers(restriction).contains(containerName)) {
                        for (ItemStack item : event.getEntity().f_36095_.m_38927_()) {
                            if (!ResourceUtil.check(restriction, item, ResourceUtil.CHECK_TYPES.ALL)) continue;
                            Utils.dropItemStack((Player)player2, item);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void clientInventoryTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        Player player = event.player;
        if (!new HashSet(player.m_150109_().f_35974_).equals(this.prevInventory) || !player.f_36095_.m_39730_().m_7983_()) {
            Registry.getRestrictions().forEach(restriction -> {
                int i;
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (!StageUtil.hasStage(player, stage) && RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getContainerListWhitelist() && !ResourceUtil.getContainers(restriction).contains("decursio_stages.inventoryMenu.CraftingGrid")) {
                    for (i = 0; i <= player.f_36095_.m_39730_().m_6643_(); ++i) {
                        if (!ResourceUtil.check(restriction, player.f_36095_.m_39730_().m_8020_(i), ResourceUtil.CHECK_TYPES.ALL)) continue;
                        Utils.dropItemStack(player, player.f_36095_.m_39730_().m_8020_(i));
                        player.f_36095_.m_6199_((Container)player.m_150109_());
                    }
                }
                if (!StageUtil.hasStage(player, stage) && !RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getContainerListWhitelist() && ResourceUtil.getContainers(restriction).contains("decursio_stages.inventoryMenu.CraftingGrid")) {
                    for (i = 0; i <= player.f_36095_.m_39730_().m_6643_(); ++i) {
                        if (!ResourceUtil.check(restriction, player.f_36095_.m_39730_().m_8020_(i), ResourceUtil.CHECK_TYPES.ALL)) continue;
                        Utils.dropItemStack(player, player.f_36095_.m_39730_().m_8020_(i));
                        player.f_36095_.m_6199_((Container)player.m_150109_());
                    }
                }
                if (RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getCheckPlayerInventory() && !StageUtil.hasStage(player, stage)) {
                    for (ItemStack item : player.m_150109_().f_35974_) {
                        if (!ResourceUtil.check(restriction, item, ResourceUtil.CHECK_TYPES.ALL)) continue;
                        Utils.dropItemStack(player, item);
                    }
                }
            });
            this.prevInventory = new HashSet<ItemStack>((Collection<ItemStack>)player.m_150109_().f_35974_);
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity().m_20193_().m_5776_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Registry.getRestrictions().forEach(restriction -> {
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getCheckPlayerEquipment() && !StageUtil.hasStage(player, stage)) {
                    for (ItemStack item : player.m_150109_().f_35975_) {
                        if (!ResourceUtil.check(restriction, item, ResourceUtil.CHECK_TYPES.ALL)) continue;
                        Utils.dropItemStack(player, item);
                    }
                }
            });
        }
    }
}

