/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.events;

import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import com.decursioteam.decursio_stages.utils.Utils;
import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockEvents {
    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Registry.getRestrictions().forEach(restriction -> {
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (!player.m_9236_().f_46443_ && StageUtil.hasStage(player, stage)) {
                    StructureManager structureManager = event.getLevel().m_7654_().m_129880_(player.m_9236_().m_46472_()).m_215010_();
                    if (!RestrictionsData.getRestrictionData(restriction).getData().getStructureList().isEmpty()) {
                        RestrictionsData.getRestrictionData(restriction).getData().getStructureList().forEach(structureRestriction -> {
                            Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(structureRestriction.getStructure());
                            if (structure != null && structureManager.m_220494_(event.getPos(), structure).m_73603_()) {
                                ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)event.getLevel().m_8055_(event.getPos()).m_60734_());
                                if (!structureRestriction.getCanPlaceBlock().booleanValue() && !structureRestriction.getCanPlaceBlockList().get().contains(registryName)) {
                                    event.setCanceled(true);
                                }
                            }
                        });
                    }
                }
                if (!RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getUsableBlocks() && !StageUtil.hasStage(player, stage) && ResourceUtil.check(restriction, new ItemStack((ItemLike)event.getLevel().m_8055_(event.getPos()).m_60734_().m_5456_()), ResourceUtil.CHECK_TYPES.ALL)) {
                    event.setCanceled(true);
                    player.m_5661_(Utils.BLOCK_INTERACT_WARN, true);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity() != null) {
            Player player = event.getEntity();
            Registry.getRestrictions().forEach(restriction -> {
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (!player.m_9236_().f_46443_ && StageUtil.hasStage(player, stage)) {
                    StructureManager structureManager = event.getLevel().m_7654_().m_129880_(player.m_9236_().m_46472_()).m_215010_();
                    if (!RestrictionsData.getRestrictionData(restriction).getData().getStructureList().isEmpty()) {
                        RestrictionsData.getRestrictionData(restriction).getData().getStructureList().forEach(structureRestriction -> {
                            Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(structureRestriction.getStructure());
                            if (structure != null && structureManager.m_220494_(event.getPos(), structure).m_73603_()) {
                                ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)event.getLevel().m_8055_(event.getPos()).m_60734_());
                                if (!structureRestriction.getCanUseBlock().booleanValue() && !structureRestriction.getUseBlockList().get().contains(registryName)) {
                                    event.setUseBlock(Event.Result.DENY);
                                }
                            }
                        });
                    }
                }
                if (!RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getUsableBlocks() && !StageUtil.hasStage(player, stage) && ResourceUtil.check(restriction, new ItemStack((ItemLike)event.getLevel().m_8055_(event.getPos()).m_60734_().m_5456_()), ResourceUtil.CHECK_TYPES.ALL)) {
                    event.setCanceled(true);
                    player.m_5661_(Utils.BLOCK_INTERACT_ERROR, true);
                }
            });
        }
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent event) {
        if (event.getLevel().m_7654_() == null) {
            return;
        }
        var ref = new Object(){
            Player closestPlayer = null;
        };
        for (ServerPlayer player : event.getLevel().m_7654_().m_6846_().m_11314_()) {
            if (ref.closestPlayer == null) {
                ref.closestPlayer = player;
            }
            if (!(player.m_20238_(event.getExplosion().getPosition()) < ref.closestPlayer.m_20238_(event.getExplosion().getPosition()))) continue;
            ref.closestPlayer = player;
        }
        if (ref.closestPlayer == null) {
            return;
        }
        Registry.getRestrictions().forEach(restriction -> {
            if (!ResourceUtil.getApplyToFakePlayer(restriction) && ref.closestPlayer instanceof FakePlayer) {
                return;
            }
            String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage();
            if (!ref.closestPlayer.m_9236_().f_46443_ && StageUtil.hasStage(ref.closestPlayer, stage)) {
                StructureManager structureManager = event.getLevel().m_7654_().m_129880_(event.getLevel().m_46472_()).m_215010_();
                if (!RestrictionsData.getRestrictionData(restriction).getData().getStructureList().isEmpty()) {
                    RestrictionsData.getRestrictionData(restriction).getData().getStructureList().forEach(structureRestriction -> {
                        Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(structureRestriction.getStructure());
                        event.getExplosion().m_46081_().forEach(blockPos -> {
                            if (structure != null && structureManager.m_220494_(blockPos, structure).m_73603_()) {
                                ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)event.getLevel().m_8055_(blockPos).m_60734_());
                                if (!structureRestriction.getCanBreakBlock().booleanValue() && !structureRestriction.getBreakBlockList().get().contains(registryName)) {
                                    event.getExplosion().m_46080_();
                                }
                            }
                        });
                    });
                }
            }
        });
    }

    @SubscribeEvent
    public void onPlayerDestroyBlock(BlockEvent.BreakEvent event) {
        Registry.getRestrictions().forEach(restriction -> {
            if (!ResourceUtil.getApplyToFakePlayer(restriction) && event.getPlayer() instanceof FakePlayer) {
                return;
            }
            String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage();
            if (!event.getPlayer().m_9236_().f_46443_ && StageUtil.hasStage(event.getPlayer(), stage)) {
                StructureManager structureManager = event.getLevel().m_7654_().m_129880_(event.getPlayer().m_9236_().m_46472_()).m_215010_();
                if (!RestrictionsData.getRestrictionData(restriction).getData().getStructureList().isEmpty()) {
                    RestrictionsData.getRestrictionData(restriction).getData().getStructureList().forEach(structureRestriction -> {
                        Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(structureRestriction.getStructure());
                        if (structure != null && structureManager.m_220494_(event.getPos(), structure).m_73603_()) {
                            ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)event.getLevel().m_8055_(event.getPos()).m_60734_());
                            if (!structureRestriction.getCanBreakBlock().booleanValue() && !structureRestriction.getBreakBlockList().get().contains(registryName)) {
                                event.setCanceled(true);
                            }
                        }
                    });
                }
            }
            if (!RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getDestroyableBlocks() && !StageUtil.hasStage(event.getPlayer(), stage) && ResourceUtil.check(restriction, new ItemStack((ItemLike)event.getLevel().m_8055_(event.getPos()).m_60734_().m_5456_()), ResourceUtil.CHECK_TYPES.ALL)) {
                event.setCanceled(true);
                event.getPlayer().m_5661_(Utils.BLOCK_DESTROY_ERROR, true);
            }
        });
    }

    @SubscribeEvent
    public void onPlayerInteractWithBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity() != null) {
            Player player = event.getEntity();
            Registry.getRestrictions().forEach(restriction -> {
                if (!ResourceUtil.getApplyToFakePlayer(restriction) && player instanceof FakePlayer) {
                    return;
                }
                String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage().toLowerCase(Locale.ROOT);
                if (!player.m_9236_().f_46443_ && StageUtil.hasStage(player, stage)) {
                    StructureManager structureManager = event.getLevel().m_7654_().m_129880_(player.m_9236_().m_46472_()).m_215010_();
                    if (!RestrictionsData.getRestrictionData(restriction).getData().getStructureList().isEmpty()) {
                        RestrictionsData.getRestrictionData(restriction).getData().getStructureList().forEach(structureRestriction -> {
                            Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(structureRestriction.getStructure());
                            if (structure != null && structureManager.m_220494_(event.getPos(), structure).m_73603_()) {
                                ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)event.getLevel().m_8055_(event.getPos()).m_60734_());
                                if (!structureRestriction.getCanBreakBlock().booleanValue() && !structureRestriction.getBreakBlockList().get().contains(registryName)) {
                                    event.setCanceled(true);
                                }
                            }
                        });
                    }
                }
                if (!RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getUsableBlocks() && !StageUtil.hasStage(player, stage) && ResourceUtil.check(restriction, new ItemStack((ItemLike)event.getLevel().m_8055_(event.getPos()).m_60734_().m_5456_()), ResourceUtil.CHECK_TYPES.ALL)) {
                    player.m_5661_(Utils.BLOCK_INTERACT_WARN, true);
                }
                if (!RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getUsableItems() && !StageUtil.hasStage(player, stage) && ResourceUtil.check(restriction, event.getItemStack(), ResourceUtil.CHECK_TYPES.ALL)) {
                    event.setCanceled(true);
                    player.m_5661_(Utils.ITEM_INTERACT_ERROR, true);
                }
            });
        }
    }
}

