/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.datagen.utils;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.datagen.Restrictions;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class FileUtils {
    public static final String JSON = ".json";
    public static final String ZIP = ".zip";
    public static final Path MOD_ROOT = ModList.get().getModFileById("decursio_stages").getFile().getFilePath();

    public static void streamFilesAndParse(Path directoryPath, BiConsumer<Reader, String> instructions, String errorMessage) {
        try (Stream<Path> zipStream = Files.walk(directoryPath, new FileVisitOption[0]);
             Stream<Path> jsonStream = Files.walk(directoryPath, new FileVisitOption[0]);){
            zipStream.filter(f -> f.getFileName().toString().endsWith(ZIP)).forEach(path -> FileUtils.addZippedFile(path, instructions));
            jsonStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(path -> FileUtils.addFile(path, instructions));
        }
        catch (IOException e) {
            DecursioStages.LOGGER.error(errorMessage, (Throwable)e);
        }
    }

    public static void setupDefaultFiles(String dataPath, Path targetPath) {
        if (Files.isRegularFile(MOD_ROOT, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(MOD_ROOT, ClassLoader.getSystemClassLoader());){
                Path path = fileSystem.getPath(dataPath, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    FileUtils.copyFiles(path, targetPath);
                }
            }
            catch (IOException e) {
                DecursioStages.LOGGER.error("Could not load source {}!!", (Object)MOD_ROOT);
                e.printStackTrace();
            }
        } else if (Files.isDirectory(MOD_ROOT, new LinkOption[0])) {
            FileUtils.copyFiles(Paths.get(MOD_ROOT.toString(), dataPath), targetPath);
        }
    }

    private static void addFile(Path path, BiConsumer<Reader, String> instructions) {
        File f = path.toFile();
        try {
            FileUtils.parseType(f, instructions);
        }
        catch (IOException e) {
            DecursioStages.LOGGER.warn("File not found: {}", (Object)path);
        }
    }

    private static void addZippedFile(Path file, BiConsumer<Reader, String> instructions) {
        try (ZipFile zf = new ZipFile(file.toString());){
            zf.stream().filter(zipEntry -> zipEntry.getName().endsWith(JSON)).forEach(zipEntry -> {
                try {
                    FileUtils.parseType(zf, zipEntry, instructions);
                }
                catch (IOException e) {
                    DecursioStages.LOGGER.error("Could not parse zip entry: {}", (Object)zipEntry.getName());
                }
            });
        }
        catch (IOException e) {
            DecursioStages.LOGGER.warn("Could not read Zip File: {}", (Object)file.getFileName());
        }
    }

    private static void parseType(File file, BiConsumer<Reader, String> consumer) throws IOException {
        String name = file.getName();
        name = name.substring(0, name.indexOf(46));
        BufferedReader r = Files.newBufferedReader(file.toPath());
        consumer.accept(r, name);
    }

    private static void parseType(ZipFile zf, ZipEntry zipEntry, BiConsumer<Reader, String> consumer) throws IOException {
        String name = zipEntry.getName();
        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
        InputStream input = zf.getInputStream(zipEntry);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        consumer.accept(reader, name);
    }

    private static void copyFiles(Path source, Path targetPath) {
        try (Stream<Path> sourceStream = Files.walk(source, new FileVisitOption[0]);){
            sourceStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(path -> {
                try {
                    Files.copy(path, Paths.get(targetPath.toString(), path.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    DecursioStages.LOGGER.error("Could not copy file: {}, Target: {}", path, (Object)targetPath);
                }
            });
        }
        catch (IOException e) {
            DecursioStages.LOGGER.error("Could not stream source files: {}", (Object)source);
        }
    }

    public static boolean restrictionExists(String restriction, String stage, String advancedTooltips, String itemTitle, int pickupDelay, boolean hideInJEI, boolean canPickup, boolean containerListWhitelist, boolean checkPlayerInventory, boolean checkPlayerEquipment, boolean usableItems, boolean usableBlocks, boolean destroyableBlocks) {
        try {
            Restrictions restrictionData = RestrictionsData.getRestrictionData(restriction);
            if (restrictionData == null) {
                return false;
            }
            return restrictionData.getData().getStage().equals(stage) && restrictionData.getSettingsCodec().getAdvancedTooltips().equals(advancedTooltips) && restrictionData.getSettingsCodec().getItemTitle().equals(itemTitle) && restrictionData.getSettingsCodec().getPickupDelay() == pickupDelay && restrictionData.getSettingsCodec().getHideInJEI() == hideInJEI && restrictionData.getSettingsCodec().getCanPickup() == canPickup && restrictionData.getSettingsCodec().getContainerListWhitelist() == containerListWhitelist && restrictionData.getSettingsCodec().getCheckPlayerInventory() == checkPlayerInventory && restrictionData.getSettingsCodec().getCheckPlayerEquipment() == checkPlayerEquipment && restrictionData.getSettingsCodec().getUsableItems() == usableItems && restrictionData.getSettingsCodec().getUsableBlocks() == usableBlocks && restrictionData.getSettingsCodec().getDestroyableBlocks() == destroyableBlocks;
        }
        catch (Exception e) {
            DecursioStages.LOGGER.error("Error checking restriction existence: {}", (Object)restriction, (Object)e);
            return false;
        }
    }

    public static boolean restrictItem(String stage, String advancedTooltips, String itemTitle, int pickupDelay, boolean hideInJEI, boolean canPickup, boolean containerListWhitelist, boolean checkPlayerInventory, boolean checkPlayerEquipment, boolean usableItems, boolean usableBlocks, boolean destroyableBlocks, ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            DecursioStages.LOGGER.warn("Attempted to restrict a null or empty item");
            return false;
        }
        JsonObject itemElement = FileUtils.createItemJson(itemStack);
        if (itemElement == null) {
            return false;
        }
        AtomicBoolean anyChanges = new AtomicBoolean(false);
        RestrictionsData.getRegistry().getRawRestrictions().forEach((restriction, jsonFile) -> {
            DecursioStages.LOGGER.info("Checking restriction: {}", restriction);
            DecursioStages.LOGGER.info("Data: {}", jsonFile);
            boolean isMatching = FileUtils.restrictionExists(restriction, stage, advancedTooltips, itemTitle, pickupDelay, hideInJEI, canPickup, containerListWhitelist, checkPlayerInventory, checkPlayerEquipment, usableItems, usableBlocks, destroyableBlocks);
            if (isMatching) {
                if (FileUtils.addItemToRestriction(restriction, jsonFile, itemStack, itemElement)) {
                    DecursioStages.LOGGER.info("Restricton matched");
                    anyChanges.set(true);
                }
            } else if (RestrictionsData.getRestrictionData(restriction) != null && !RestrictionsData.getRestrictionData(restriction).getData().getStage().equals(stage) && FileUtils.updateExceptionsList(restriction, jsonFile, itemStack, itemElement)) {
                anyChanges.set(true);
            }
        });
        return anyChanges.get();
    }

    private static JsonObject createItemJson(ItemStack itemStack) {
        try {
            JsonObject itemElement = new JsonObject();
            itemElement.addProperty("item", ResourceUtil.getRegistryName(itemStack.m_41720_()).toString());
            if (itemStack.m_41782_()) {
                try {
                    JsonElement nbtJson = (JsonElement)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)itemStack.m_41783_());
                    if (nbtJson != null) {
                        itemElement.add("nbt", nbtJson);
                    }
                }
                catch (Exception e) {
                    DecursioStages.LOGGER.error("Error adding NBT data", (Throwable)e);
                }
            }
            return itemElement;
        }
        catch (Exception e) {
            DecursioStages.LOGGER.error("Failed to create JSON for item: {}", (Object)itemStack, (Object)e);
            return null;
        }
    }

    private static boolean addItemToRestriction(String restriction, JsonObject jsonFile, ItemStack itemStack, JsonObject itemElement) {
        try {
            boolean changed = false;
            JsonArray itemList = jsonFile.get("Restriction Data").getAsJsonObject().get("itemList").getAsJsonArray();
            DecursioStages.LOGGER.info(jsonFile.toString());
            boolean alreadyExists = false;
            for (int i = 0; i < itemList.size(); ++i) {
                if (!FileUtils.itemsMatch(itemList.get(i).getAsJsonObject(), itemElement)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                itemList.add((JsonElement)itemElement);
                DecursioStages.LOGGER.info("Successfully added item {} for stage", (Object)itemList);
                changed = true;
            }
            JsonArray exceptionList = jsonFile.get("Restriction Data").getAsJsonObject().get("exceptionList").getAsJsonArray();
            for (int i = 0; i < exceptionList.size(); ++i) {
                if (!FileUtils.itemsMatch(exceptionList.get(i).getAsJsonObject(), itemElement)) continue;
                exceptionList.remove(i);
                changed = true;
                break;
            }
            if (changed) {
                FileUtils.saveRestrictionFile(restriction, jsonFile);
            }
            return changed;
        }
        catch (Exception e) {
            DecursioStages.LOGGER.error("Error adding item to restriction {}: {}", (Object)restriction, (Object)e.getMessage());
            return false;
        }
    }

    private static boolean updateExceptionsList(String restriction, JsonObject jsonFile, ItemStack itemStack, JsonObject itemElement) {
        try {
            boolean changed = false;
            JsonArray itemList = jsonFile.get("Restriction Data").getAsJsonObject().get("itemList").getAsJsonArray();
            for (int i = 0; i < itemList.size(); ++i) {
                if (!FileUtils.itemsMatch(itemList.get(i).getAsJsonObject(), itemElement)) continue;
                itemList.remove(i);
                changed = true;
                break;
            }
            if (ResourceUtil.isItemExcluded(restriction, itemStack)) {
                JsonArray exceptionList = jsonFile.get("Restriction Data").getAsJsonObject().get("exceptionList").getAsJsonArray();
                boolean alreadyInExceptions = false;
                for (int i = 0; i < exceptionList.size(); ++i) {
                    if (!FileUtils.itemsMatch(exceptionList.get(i).getAsJsonObject(), itemElement)) continue;
                    alreadyInExceptions = true;
                    break;
                }
                if (!alreadyInExceptions) {
                    exceptionList.add((JsonElement)itemElement);
                    changed = true;
                }
            }
            if (changed) {
                FileUtils.saveRestrictionFile(restriction, jsonFile);
            }
            return changed;
        }
        catch (Exception e) {
            DecursioStages.LOGGER.error("Error updating exceptions list for restriction {}: {}", (Object)restriction, (Object)e.getMessage());
            return false;
        }
    }

    private static boolean itemsMatch(JsonObject item1, JsonObject item2) {
        if (!item1.has("item") || !item2.has("item")) {
            return false;
        }
        if (!item1.get("item").getAsString().equals(item2.get("item").getAsString())) {
            return false;
        }
        if (item1.has("nbt") && item2.has("nbt")) {
            return item1.get("nbt").toString().equals(item2.get("nbt").toString());
        }
        return !item1.has("nbt") && !item2.has("nbt");
    }

    public static void saveRestrictionFile(String restriction, JsonObject jsonFile) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonOutput = gson.toJson((JsonElement)jsonFile);
            Path filePath = Paths.get(String.valueOf(FileUtils.createCustomPath("restrictions")) + "/" + restriction + JSON, new String[0]);
            Files.writeString(filePath, (CharSequence)jsonOutput, StandardCharsets.UTF_8, new OpenOption[0]);
            RestrictionsData.getRegistry().cacheRawRestrictionsData(restriction, jsonFile);
        }
        catch (Exception e) {
            DecursioStages.LOGGER.error("Failed to save restriction file {}: {}", (Object)restriction, (Object)e.getMessage());
        }
    }

    public static void addRestriction(String stage, String advancedTooltips, String itemTitle, int pickupDelay, boolean hideInJEI, boolean canPickup, boolean containerListWhitelist, boolean checkPlayerInventory, boolean checkPlayerEquipment, boolean usableItems, boolean usableBlocks, boolean destroyableBlocks) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject jsonFile = new JsonObject();
        JsonObject restrictionData = new JsonObject();
        JsonObject settings = new JsonObject();
        JsonArray itemList = new JsonArray();
        JsonArray exceptionList = new JsonArray();
        jsonFile.add("Restriction Data", (JsonElement)restrictionData);
        jsonFile.add("Settings", (JsonElement)settings);
        restrictionData.addProperty("stage", stage);
        restrictionData.add("itemList", (JsonElement)itemList);
        restrictionData.add("exceptionList", (JsonElement)exceptionList);
        settings.addProperty("advancedTooltips", advancedTooltips);
        settings.addProperty("itemsTitle", itemTitle);
        settings.addProperty("itemsPickupDelay", (Number)pickupDelay);
        settings.addProperty("hideInJEI_REI", Boolean.valueOf(hideInJEI));
        settings.addProperty("canPickupItems", Boolean.valueOf(canPickup));
        settings.addProperty("containerListWhitelist", Boolean.valueOf(containerListWhitelist));
        settings.addProperty("dropItemsFromInventory", Boolean.valueOf(checkPlayerInventory));
        settings.addProperty("dropArmorFromInventory", Boolean.valueOf(checkPlayerEquipment));
        settings.addProperty("canUseItems", Boolean.valueOf(usableItems));
        settings.addProperty("canBreakBlocks", Boolean.valueOf(destroyableBlocks));
        settings.addProperty("canRightClickBlocks", Boolean.valueOf(usableBlocks));
        String normalizedStage = stage.toLowerCase().replace(" ", "_");
        String normalizedTitle = itemTitle.toLowerCase().replace(" ", "_");
        String restrictionId = normalizedStage + "_" + normalizedTitle;
        String jsonOutput = gson.toJson((JsonElement)jsonFile);
        try (PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(FileUtils.createCustomPath("restrictions")) + "/" + restrictionId + JSON));){
            out.write(jsonOutput);
            RestrictionsData.getRegistry().cacheRawRestrictionsData(restrictionId, jsonFile);
            RestrictionsData.getRegistry().regenerateCustomRestrictionData();
            Registry.registerRestrictionsList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "decursio_stages", pathName);
        FileUtils.createDirectory(customPath, pathName);
        return customPath;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            DecursioStages.LOGGER.error("failed to create \"{}\" directory", (Object)dirName);
        }
    }
}

