/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.datagen;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.codec.RestrictionCodec;
import com.decursioteam.decursio_stages.codec.SettingsCodec;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;

public class Restrictions {
    public static final Restrictions DEFAULT = new Restrictions(RestrictionCodec.DEFAULT, SettingsCodec.DEFAULT);
    protected RestrictionCodec restrictionCodec;
    protected SettingsCodec settingsCodec;
    protected JsonObject rawData;

    public static Codec<Restrictions> codec(String name) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RestrictionCodec.codec(name).fieldOf("Restriction Data").orElseGet(s -> DecursioStages.LOGGER.error("Restriction Data is required!"), null).forGetter(Restrictions::getData), (App)SettingsCodec.CODEC.fieldOf("Settings").orElse((Object)SettingsCodec.DEFAULT).forGetter(Restrictions::getSettingsCodec)).apply((Applicative)instance, Restrictions::new));
    }

    private Restrictions(RestrictionCodec restrictionCodec, SettingsCodec settingsCodec) {
        this.restrictionCodec = restrictionCodec;
        this.settingsCodec = settingsCodec;
        this.rawData = RestrictionsData.getRegistry().getRawORestrictionsData(restrictionCodec.getName());
    }

    private Restrictions(Mutable mutable) {
        this.restrictionCodec = mutable.restrictionCodec.toImmutable();
        this.settingsCodec = mutable.settingsCodec.toImmutable();
        this.rawData = mutable.rawData;
    }

    public RestrictionCodec getData() {
        return this.restrictionCodec;
    }

    public SettingsCodec getSettingsCodec() {
        return this.settingsCodec;
    }

    @Nullable
    public JsonObject getRawData() {
        return this.rawData;
    }

    public Restrictions toImmutable() {
        return this;
    }

    public static class Mutable
    extends Restrictions {
        public Mutable(RestrictionCodec restrictionCodec, SettingsCodec settingsCodec) {
            super(restrictionCodec, settingsCodec);
        }

        public Mutable() {
            super(RestrictionCodec.DEFAULT, SettingsCodec.DEFAULT);
        }

        public Mutable setData(RestrictionCodec restrictionCodec) {
            this.restrictionCodec = restrictionCodec;
            return this;
        }

        public Mutable setData(SettingsCodec settingsCodec) {
            this.settingsCodec = settingsCodec;
            return this;
        }

        public Mutable setRawData(JsonObject rawData) {
            this.rawData = rawData;
            return this;
        }

        @Override
        public Restrictions toImmutable() {
            return new Restrictions(this);
        }
    }
}

