/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.compat.plugins;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.Registry;
import com.decursioteam.decursio_stages.config.CommonConfig;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.IStagesData;
import com.decursioteam.decursio_stages.events.SyncStagesEvent;
import com.decursioteam.decursio_stages.restrictions.FluidRestriction;
import com.decursioteam.decursio_stages.utils.ResourceUtil;
import com.decursioteam.decursio_stages.utils.StageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;

@REIPluginClient
public class DecursioStagesREI
implements REIClientPlugin {
    private final List<EntryStack<?>> hiddenEntries = new ArrayList();

    public DecursioStagesREI() {
        if (EffectiveSide.get().isClient()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, SyncStagesEvent.class, e -> this.updateItems());
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, false, RecipesUpdatedEvent.class, e -> this.updateItems());
        }
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        this.updateItems();
    }

    private void updateItems() {
        EntryRegistry entryRegistry = EntryRegistry.getInstance();
        BasicFilteringRule rule = FilteringRuleTypeRegistry.getInstance().basic();
        this.collectEntries(rule);
        this.collectEntries(entryRegistry);
        this.hideEntries(rule);
    }

    private void collectEntries(BasicFilteringRule<?> rule) {
        if (!this.hiddenEntries.isEmpty()) {
            if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.info("Restoring the following items at runtime: " + String.valueOf(this.hiddenEntries));
            }
            for (EntryStack<?> stack : this.hiddenEntries) {
                rule.show(stack);
            }
            this.hiddenEntries.clear();
        } else if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.warn("There are no items available for restoring to the REI ingredient list!");
        }
    }

    private void collectEntries(EntryRegistry registry) {
        registry.getEntryStacks().forEach(entryStack -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            IStagesData stageData = StageUtil.getPlayerData((Player)player);
            try {
                Registry.getRestrictionsHashSet().forEach(restriction -> {
                    String stage = RestrictionsData.getRestrictionData(restriction).getData().getStage();
                    assert (stageData != null);
                    if (!stageData.hasStage(stage) && RestrictionsData.getRestrictionData(restriction).getSettingsCodec().getHideInJEI() && ForgeRegistries.ITEMS.getDelegate(entryStack.getIdentifier()).isPresent()) {
                        ItemStack stack = new ItemStack((Holder)ForgeRegistries.ITEMS.getDelegate(entryStack.getIdentifier()).get());
                        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(entryStack.getIdentifier());
                        if (!ResourceUtil.getFluids(restriction).isEmpty() && fluid != null) {
                            for (FluidRestriction fluidRestriction : ResourceUtil.getFluids(restriction)) {
                                if (fluidRestriction.getFluid() != null) {
                                    if (!fluid.m_6212_(fluidRestriction.getFluid())) continue;
                                    this.add((EntryStack<?>)entryStack);
                                    continue;
                                }
                                if (fluidRestriction.getTag() != null) {
                                    if (!fluid.m_205067_(Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).createTagKey(fluidRestriction.getTag()))) continue;
                                    this.add((EntryStack<?>)entryStack);
                                    continue;
                                }
                                if (fluidRestriction.getMod() == null || !Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluid)).m_135827_().equals(fluidRestriction.getMod())) continue;
                                this.add((EntryStack<?>)entryStack);
                            }
                        }
                        if (!ResourceUtil.getMods(restriction).isEmpty() && ResourceUtil.check(restriction, stack, ResourceUtil.CHECK_TYPES.MOD)) {
                            this.add((EntryStack<?>)entryStack);
                        }
                        if (!ResourceUtil.getTags(restriction).isEmpty() && ResourceUtil.check(restriction, stack, ResourceUtil.CHECK_TYPES.TAG)) {
                            this.add((EntryStack<?>)entryStack);
                        }
                        if (!ResourceUtil.getItems(restriction).isEmpty() && ResourceUtil.check(restriction, stack, ResourceUtil.CHECK_TYPES.ITEM)) {
                            this.add((EntryStack<?>)entryStack);
                        }
                    }
                });
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    private void hideEntries(BasicFilteringRule<?> rule) {
        if (!this.hiddenEntries.isEmpty()) {
            if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
                DecursioStages.LOGGER.info("Hiding the following items: " + String.valueOf(this.hiddenEntries));
            }
            for (EntryStack<?> stack : this.hiddenEntries) {
                rule.hide(stack);
            }
        } else if (((Boolean)CommonConfig.debugMode.get()).booleanValue()) {
            DecursioStages.LOGGER.warn("There are no items that are supposed to be hidden in REI");
        }
    }

    private void add(EntryStack<?> entryStack) {
        this.hiddenEntries.add(entryStack);
    }

    private void add(List<EntryStack<?>> entryStacks) {
        this.hiddenEntries.addAll(entryStacks);
    }
}

