/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.compat.ftbquests;

import com.decursioteam.decursio_stages.compat.ftbquests.DecursioQuestIntegration;
import com.decursioteam.decursio_stages.utils.StageUtil;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DecursioStageReward
extends Reward {
    private String stage = "";
    private boolean remove = false;

    public DecursioStageReward(long id, Quest quest) {
        super(id, quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    public RewardType getType() {
        return DecursioQuestIntegration.DECURSIO_STAGE_REWARD;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("stage", this.stage);
        if (this.remove) {
            nbt.m_128379_("remove", true);
        }
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stage = nbt.m_128461_("stage");
        this.remove = nbt.m_128471_("remove");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.stage, Short.MAX_VALUE);
        buffer.writeBoolean(this.remove);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.m_130136_(Short.MAX_VALUE);
        this.remove = buffer.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.reward.ftbquests.decursiostage");
        config.addBool("remove", this.remove, v -> {
            this.remove = v;
        }, false);
    }

    public void claim(ServerPlayer player, boolean notify) {
        if (this.remove) {
            StageUtil.removeStage(player, this.stage);
        } else {
            StageUtil.addStage(player, this.stage);
        }
        if (notify) {
            if (this.remove) {
                player.m_240418_((Component)Component.m_237110_((String)"decursio_stages.commands.removestage.success.target", (Object[])new Object[]{this.stage}), true);
            } else {
                player.m_240418_((Component)Component.m_237110_((String)"decursio_stages.commands.addstage.success.target", (Object[])new Object[]{this.stage}), true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.reward.ftbquests.decursiostage").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.stage).m_130940_(ChatFormatting.DARK_PURPLE));
    }

    public boolean ignoreRewardBlocking() {
        return true;
    }

    protected boolean isIgnoreRewardBlockingHardcoded() {
        return true;
    }
}

