/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.client.screens;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.client.screens.RestrictMenu;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.FileUtils;
import com.decursioteam.decursio_stages.network.messages.SaveRestrictionMessage;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RestrictScreen
extends AbstractContainerScreen<RestrictMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("decursio_stages", "textures/gui/restrict_screen.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private final int imageWidth = 176;
    private final int imageHeight;
    private EditBox stageField;
    private EditBox titleField;
    private EditBox pickupDelayField;
    private ToggleButton hideInJEIButton;
    private ToggleButton canPickupButton;
    private ToggleButton containerWhitelistButton;
    private ToggleButton checkInventoryButton;
    private ToggleButton checkEquipmentButton;
    private ToggleButton usableItemsButton;
    private ToggleButton usableBlocksButton;
    private ToggleButton destroyableBlocksButton;
    private TooltipModeButton advancedTooltipsButton;
    private List<String> restrictionsList = new ArrayList<String>();
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_ENTRIES = 7;
    private Button scrollUpButton;
    private Button scrollDownButton;
    private List<RestrictionListEntry> listEntries = new ArrayList<RestrictionListEntry>();
    private Button saveButton;
    private Button clearButton;
    private Button deleteButton;
    private String selectedRestrictionName = null;
    private boolean isUpdatingFromSelection = false;

    public RestrictScreen(RestrictMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = menu.getRequiredHeight();
        this.f_97731_ = 131;
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        this.f_97730_ = 8;
    }

    protected void m_7856_() {
        this.f_97735_ = 20;
        this.f_97736_ = 20;
        this.selectedRestrictionName = null;
        int textY = this.f_97736_ + 10;
        int rightColumnX = this.f_97735_ + 176 + 15;
        this.stageField = new EditBox(this.f_96547_, rightColumnX, textY + 20, 110, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.stage"));
        this.stageField.m_94199_(32);
        this.stageField.m_94144_("");
        this.stageField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.stage.tooltip")));
        this.titleField = new EditBox(this.f_96547_, rightColumnX, textY + 50, 110, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.item_title"));
        this.titleField.m_94199_(32);
        this.titleField.m_94144_("Locked Item");
        this.titleField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.item_title.tooltip")));
        this.pickupDelayField = new EditBox(this.f_96547_, rightColumnX, textY + 80, 50, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.pickup_delay"));
        this.pickupDelayField.m_94199_(3);
        this.pickupDelayField.m_94144_("40");
        this.pickupDelayField.m_94153_(s -> s.matches("\\d*"));
        this.pickupDelayField.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.pickup_delay.tooltip")));
        this.m_7787_((GuiEventListener)this.stageField);
        this.m_7787_((GuiEventListener)this.titleField);
        this.m_7787_((GuiEventListener)this.pickupDelayField);
        int toggleX = rightColumnX;
        int toggleY = textY + 120;
        int toggleSpacing = 20;
        int toggleWidth = 130;
        this.hideInJEIButton = new ToggleButton(toggleX, toggleY, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.hide_in_jei"), true);
        this.hideInJEIButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.hide_in_jei.tooltip")));
        this.canPickupButton = new ToggleButton(toggleX, toggleY + toggleSpacing, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.can_pickup"), false);
        this.canPickupButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.can_pickup.tooltip")));
        this.containerWhitelistButton = new ToggleButton(toggleX, toggleY + toggleSpacing * 2, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.container_whitelist"), true);
        this.containerWhitelistButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.container_whitelist.tooltip")));
        this.checkInventoryButton = new ToggleButton(toggleX, toggleY + toggleSpacing * 3, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.check_inventory"), true);
        this.checkInventoryButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.check_inventory.tooltip")));
        this.checkEquipmentButton = new ToggleButton(toggleX, toggleY + toggleSpacing * 4, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.check_equipment"), true);
        this.checkEquipmentButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.check_equipment.tooltip")));
        this.usableItemsButton = new ToggleButton(toggleX, toggleY + toggleSpacing * 5, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.usable_items"), false);
        this.usableItemsButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.usable_items.tooltip")));
        this.usableBlocksButton = new ToggleButton(toggleX, toggleY + toggleSpacing * 6, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.usable_blocks"), false);
        this.usableBlocksButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.usable_blocks.tooltip")));
        this.destroyableBlocksButton = new ToggleButton(toggleX, toggleY + toggleSpacing * 7, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.destroyable_blocks"), false);
        this.destroyableBlocksButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.destroyable_blocks.tooltip")));
        this.advancedTooltipsButton = new TooltipModeButton(toggleX, toggleY + toggleSpacing * 8, toggleWidth, 16, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.advanced_tooltips"), TooltipMode.ALWAYS);
        this.advancedTooltipsButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.advanced_tooltips.tooltip")));
        this.m_142416_((GuiEventListener)this.hideInJEIButton);
        this.m_142416_((GuiEventListener)this.canPickupButton);
        this.m_142416_((GuiEventListener)this.containerWhitelistButton);
        this.m_142416_((GuiEventListener)this.checkInventoryButton);
        this.m_142416_((GuiEventListener)this.checkEquipmentButton);
        this.m_142416_((GuiEventListener)this.usableItemsButton);
        this.m_142416_((GuiEventListener)this.usableBlocksButton);
        this.m_142416_((GuiEventListener)this.destroyableBlocksButton);
        this.m_142416_((GuiEventListener)this.advancedTooltipsButton);
        this.updateRestrictionsList();
        this.updateListEntries();
    }

    private void updateRestrictionsList() {
        this.restrictionsList.clear();
        RestrictionsData.getRegistry().getRawRestrictions().forEach((name, jsonObject) -> this.restrictionsList.add((String)name));
    }

    private void updateListEntries() {
        this.listEntries.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.listEntries.clear();
        int rightColumnX = this.f_97735_ + 176 + 5;
        int farRightColumnX = rightColumnX + 140;
        if (this.scrollUpButton != null) {
            this.m_169411_((GuiEventListener)this.scrollUpButton);
        }
        if (this.scrollDownButton != null) {
            this.m_169411_((GuiEventListener)this.scrollDownButton);
        }
        int listStartY = this.f_97736_ + 40;
        int listHeight = 126;
        int listEndY = listStartY + listHeight;
        int entryListWidth = 110;
        int scrollButtonCenterX = farRightColumnX + entryListWidth / 2 - 10;
        this.scrollUpButton = Button.m_253074_((Component)Component.m_237113_((String)"\u25b2"), this::onScrollUpClicked).m_252794_(scrollButtonCenterX, listStartY - 20).m_253046_(20, 20).m_253136_();
        this.scrollDownButton = Button.m_253074_((Component)Component.m_237113_((String)"\u25bc"), this::onScrollDownClicked).m_252794_(scrollButtonCenterX, listEndY + 5).m_253046_(20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.scrollUpButton);
        this.m_142416_((GuiEventListener)this.scrollDownButton);
        int listX = farRightColumnX;
        int listY = listStartY + 5;
        int listWidth = 110;
        int listItemHeight = 16;
        int listSpacing = 18;
        int endIndex = Math.min(this.scrollOffset + 7, this.restrictionsList.size());
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            String restrictionName = this.restrictionsList.get(i);
            RestrictionListEntry entry = new RestrictionListEntry(listX, listY + (i - this.scrollOffset) * listSpacing, listWidth, listItemHeight, restrictionName, this::onRestrictionSelected);
            this.listEntries.add(entry);
            this.m_142416_((GuiEventListener)entry);
        }
        this.scrollUpButton.f_93623_ = this.scrollOffset > 0;
        this.scrollDownButton.f_93623_ = this.scrollOffset + 7 < this.restrictionsList.size();
        int buttonY = listEndY + 30;
        this.clearButton = Button.m_253074_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.clear"), this::onClearClicked).m_252794_(farRightColumnX, buttonY).m_253046_(110, 20).m_253136_();
        this.deleteButton = Button.m_253074_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.delete").m_130940_(ChatFormatting.RED), this::onDeleteClicked).m_252794_(farRightColumnX, buttonY + 25).m_253046_(53, 20).m_253136_();
        this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.save"), this::onSaveClicked).m_252794_(farRightColumnX + 57, buttonY + 25).m_253046_(53, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.clearButton);
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.m_142416_((GuiEventListener)this.saveButton);
    }

    private void onScrollUpClicked(Button button) {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.updateListEntries();
        }
    }

    private void onScrollDownClicked(Button button) {
        if (this.scrollOffset + 7 < this.restrictionsList.size()) {
            ++this.scrollOffset;
            this.updateListEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRestrictionSelected(String restrictionName) {
        JsonObject restriction = RestrictionsData.getRegistry().getRawORestrictionsData(restrictionName);
        if (restriction != null) {
            try {
                this.isUpdatingFromSelection = true;
                this.selectedRestrictionName = restrictionName;
                String stage = restriction.getAsJsonObject("Restriction Data").get("stage").getAsString();
                this.stageField.m_94144_(stage);
                JsonObject settings = restriction.getAsJsonObject("Settings");
                this.titleField.m_94144_(settings.get("itemsTitle").getAsString());
                this.pickupDelayField.m_94144_(String.valueOf(settings.get("itemsPickupDelay").getAsInt()));
                this.hideInJEIButton.setValue(settings.get("hideInJEI_REI").getAsBoolean());
                this.canPickupButton.setValue(settings.get("canPickupItems").getAsBoolean());
                this.containerWhitelistButton.setValue(settings.get("containerListWhitelist").getAsBoolean());
                this.checkInventoryButton.setValue(settings.get("dropItemsFromInventory").getAsBoolean());
                this.checkEquipmentButton.setValue(settings.get("dropArmorFromInventory").getAsBoolean());
                this.usableItemsButton.setValue(settings.get("canUseItems").getAsBoolean());
                this.usableBlocksButton.setValue(settings.get("canRightClickBlocks").getAsBoolean());
                this.destroyableBlocksButton.setValue(settings.get("canBreakBlocks").getAsBoolean());
                String tooltipSetting = settings.has("advancedTooltips") ? settings.get("advancedTooltips").getAsString() : "ALWAYS";
                this.advancedTooltipsButton.setValue(TooltipMode.fromString(tooltipSetting));
                ((RestrictMenu)this.f_97732_).clearItems();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"decursio_stages.gui.restrict.loaded", (Object[])new Object[]{restrictionName}).m_130940_(ChatFormatting.GREEN), false);
            }
            finally {
                this.isUpdatingFromSelection = false;
            }
        }
    }

    private void onFieldChanged(String newValue) {
        if (this.selectedRestrictionName != null && !this.isUpdatingFromSelection) {
            this.updateSelectedRestriction();
        }
    }

    private void onToggleChanged(String propertyName, Object newValue) {
        if (this.selectedRestrictionName != null && !this.isUpdatingFromSelection) {
            this.updateSelectedRestriction();
        }
    }

    private void onDeleteClicked(Button button) {
        if (this.selectedRestrictionName == null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.delete.no_selection").m_130940_(ChatFormatting.RED), false);
            return;
        }
        try {
            Path filePath = Paths.get(String.valueOf(FileUtils.createCustomPath("restrictions")) + "/" + this.selectedRestrictionName + ".json", new String[0]);
            Files.deleteIfExists(filePath);
            RestrictionsData.getRegistry().clearCustomRestrictionData();
            RestrictionsData.getRegistry().regenerateCustomRestrictionData();
            this.onClearClicked(null);
            this.selectedRestrictionName = null;
            this.updateRestrictionsList();
            this.updateListEntries();
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"decursio_stages.gui.restrict.delete.success", (Object[])new Object[]{this.selectedRestrictionName}).m_130940_(ChatFormatting.GREEN), false);
        }
        catch (Exception e) {
            DecursioStages.LOGGER.error("Error deleting restriction: {}", (Object)this.selectedRestrictionName, (Object)e);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.delete.error").m_130940_(ChatFormatting.RED), false);
        }
    }

    private void updateSelectedRestriction() {
        if (this.selectedRestrictionName == null) {
            return;
        }
        try {
            JsonObject restriction = RestrictionsData.getRegistry().getRawORestrictionsData(this.selectedRestrictionName);
            if (restriction == null) {
                return;
            }
            String stage = this.stageField.m_94155_().trim();
            if (!stage.isEmpty()) {
                restriction.getAsJsonObject("Restriction Data").addProperty("stage", stage);
            }
            JsonObject settings = restriction.getAsJsonObject("Settings");
            settings.addProperty("itemsTitle", this.titleField.m_94155_());
            try {
                int pickupDelay = Integer.parseInt(this.pickupDelayField.m_94155_());
                settings.addProperty("itemsPickupDelay", (Number)pickupDelay);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            settings.addProperty("hideInJEI_REI", Boolean.valueOf(this.hideInJEIButton.getValue()));
            settings.addProperty("canPickupItems", Boolean.valueOf(this.canPickupButton.getValue()));
            settings.addProperty("containerListWhitelist", Boolean.valueOf(this.containerWhitelistButton.getValue()));
            settings.addProperty("dropItemsFromInventory", Boolean.valueOf(this.checkInventoryButton.getValue()));
            settings.addProperty("dropArmorFromInventory", Boolean.valueOf(this.checkEquipmentButton.getValue()));
            settings.addProperty("canUseItems", Boolean.valueOf(this.usableItemsButton.getValue()));
            settings.addProperty("canRightClickBlocks", Boolean.valueOf(this.usableBlocksButton.getValue()));
            settings.addProperty("canBreakBlocks", Boolean.valueOf(this.destroyableBlocksButton.getValue()));
            settings.addProperty("advancedTooltips", this.advancedTooltipsButton.getValue().getValue());
            FileUtils.saveRestrictionFile(this.selectedRestrictionName, restriction);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"decursio_stages.gui.restrict.update_success", (Object[])new Object[]{this.selectedRestrictionName}).m_130940_(ChatFormatting.GREEN), false);
        }
        catch (Exception e) {
            DecursioStages.LOGGER.error("Error updating restriction: {}", (Object)this.selectedRestrictionName, (Object)e);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.update_error").m_130940_(ChatFormatting.RED), false);
        }
    }

    private void onSaveClicked(Button button) {
        int pickupDelay;
        String stage = this.stageField.m_94155_().trim();
        String itemTitle = this.titleField.m_94155_().trim();
        try {
            pickupDelay = Integer.parseInt(this.pickupDelayField.m_94155_());
        }
        catch (NumberFormatException e) {
            pickupDelay = 40;
        }
        boolean hideInJEI = this.hideInJEIButton.getValue();
        boolean canPickup = this.canPickupButton.getValue();
        boolean containerWhitelist = this.containerWhitelistButton.getValue();
        boolean checkInventory = this.checkInventoryButton.getValue();
        boolean checkEquipment = this.checkEquipmentButton.getValue();
        boolean usableItems = this.usableItemsButton.getValue();
        boolean usableBlocks = this.usableBlocksButton.getValue();
        boolean destroyableBlocks = this.destroyableBlocksButton.getValue();
        String advancedTooltips = this.advancedTooltipsButton.getValue().getValue();
        List<ItemStack> itemStacks = ((RestrictMenu)this.f_97732_).getRestrictedItems();
        if (stage.isEmpty()) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.error.no_stage").m_130940_(ChatFormatting.RED), false);
            return;
        }
        if (itemTitle.isEmpty()) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.error.no_title").m_130940_(ChatFormatting.RED), false);
            return;
        }
        if (itemStacks.isEmpty()) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"decursio_stages.gui.restrict.error.no_item").m_130940_(ChatFormatting.RED), false);
            return;
        }
        boolean isUpdate = this.selectedRestrictionName != null;
        FileUtils.addRestriction(stage, advancedTooltips, itemTitle, pickupDelay, hideInJEI, canPickup, containerWhitelist, checkInventory, checkEquipment, usableItems, usableBlocks, destroyableBlocks);
        for (ItemStack item : itemStacks) {
            if (item.m_41619_()) continue;
            DecursioStages.NETWORK.sendToServer(new SaveRestrictionMessage(stage, advancedTooltips, itemTitle, pickupDelay, hideInJEI, canPickup, containerWhitelist, checkInventory, checkEquipment, usableItems, usableBlocks, destroyableBlocks, item));
        }
        this.updateRestrictionsList();
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)(isUpdate ? "decursio_stages.gui.restrict.update_success" : "decursio_stages.gui.restrict.success"), (Object[])new Object[]{itemStacks.size()}).m_130940_(ChatFormatting.GREEN), false);
        this.m_7379_();
    }

    private void onClearClicked(Button button) {
        this.stageField.m_94144_("");
        this.titleField.m_94144_("Locked Item");
        this.pickupDelayField.m_94144_("40");
        this.hideInJEIButton.setValue(true);
        this.canPickupButton.setValue(false);
        this.containerWhitelistButton.setValue(true);
        this.checkInventoryButton.setValue(true);
        this.checkEquipmentButton.setValue(true);
        this.usableItemsButton.setValue(false);
        this.usableBlocksButton.setValue(false);
        this.destroyableBlocksButton.setValue(false);
        this.advancedTooltipsButton.setValue(TooltipMode.ALWAYS);
        ((RestrictMenu)this.f_97732_).clearItems();
        this.selectedRestrictionName = null;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        graphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, 176, this.imageHeight, 256, 256);
        int rightColumnX = this.f_97735_ + 176 + 5;
        int farRightColumnX = rightColumnX + 140;
        int panelWidth = 260;
        int listHeight = 126;
        int buttonAreaHeight = 75;
        int requiredHeight = Math.max(this.imageHeight + 100, listHeight + buttonAreaHeight + 90);
        graphics.m_280509_(rightColumnX, this.f_97736_, rightColumnX + panelWidth, this.f_97736_ + requiredHeight, Integer.MIN_VALUE);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.m_7286_(graphics, partialTick, mouseX, mouseY);
        int rightColumnX = this.f_97735_ + 176 + 15;
        int farRightColumnX = rightColumnX + 140;
        int textY = this.f_97736_;
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.stage"), rightColumnX, textY + 20, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.item_title"), rightColumnX, textY + 50, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.pickup_delay"), rightColumnX, textY + 80, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.settings"), rightColumnX, textY + 120, 0xFFFFFF, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"decursio_stages.gui.restrict.existing"), farRightColumnX, this.f_97736_ + 10, 0xFFFFFF, false);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.stageField.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.titleField.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.pickupDelayField.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private static class ToggleButton
    extends Button {
        private boolean value;
        private final String baseText;
        private Consumer<Boolean> changeListener;

        public ToggleButton(int x, int y, int width, int height, Component text, boolean defaultValue) {
            super(x, y, width, height, text, button -> {}, f_252438_);
            this.value = defaultValue;
            this.baseText = text.getString();
            this.updateMessage();
        }

        private void updateMessage() {
            String status = this.value ? String.valueOf(ChatFormatting.GREEN) + "ON" : String.valueOf(ChatFormatting.RED) + "OFF";
            this.m_93666_((Component)Component.m_237113_((String)(this.baseText + ": " + status)));
        }

        public void m_5691_() {
            super.m_5691_();
            this.value = !this.value;
            this.updateMessage();
            if (this.changeListener != null) {
                this.changeListener.accept(this.value);
            }
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            boolean changed = this.value != value;
            this.value = value;
            this.updateMessage();
            if (changed && this.changeListener != null) {
                this.changeListener.accept(value);
            }
        }

        public void setChangeListener(Consumer<Boolean> listener) {
            this.changeListener = listener;
        }
    }

    private static class TooltipModeButton
    extends Button {
        private TooltipMode value;
        private final String baseText;
        private Consumer<TooltipMode> changeListener;

        public TooltipModeButton(int x, int y, int width, int height, Component text, TooltipMode defaultValue) {
            super(x, y, width, height, text, button -> {}, f_252438_);
            this.value = defaultValue;
            this.baseText = text.getString();
            this.updateMessage();
        }

        private void updateMessage() {
            this.m_93666_((Component)Component.m_237113_((String)(this.baseText + ": " + String.valueOf(switch (this.value) {
                case TooltipMode.ALWAYS -> ChatFormatting.GREEN;
                case TooltipMode.NONE -> ChatFormatting.RED;
                case TooltipMode.ADVANCED -> ChatFormatting.GOLD;
                default -> ChatFormatting.WHITE;
            }) + this.value.getValue())));
        }

        public void m_5691_() {
            super.m_5691_();
            switch (this.value) {
                case ALWAYS: {
                    this.value = TooltipMode.NONE;
                    break;
                }
                case NONE: {
                    this.value = TooltipMode.ADVANCED;
                    break;
                }
                case ADVANCED: {
                    this.value = TooltipMode.ALWAYS;
                }
            }
            this.updateMessage();
            if (this.changeListener != null) {
                this.changeListener.accept(this.value);
            }
        }

        public TooltipMode getValue() {
            return this.value;
        }

        public void setValue(TooltipMode value) {
            boolean changed = this.value != value;
            this.value = value;
            this.updateMessage();
            if (changed && this.changeListener != null) {
                this.changeListener.accept(value);
            }
        }

        public void setChangeListener(Consumer<TooltipMode> listener) {
            this.changeListener = listener;
        }
    }

    public static enum TooltipMode {
        ALWAYS("ALWAYS"),
        NONE("NONE"),
        ADVANCED("ADVANCED");

        private final String value;

        private TooltipMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static TooltipMode fromString(String text) {
            for (TooltipMode mode : TooltipMode.values()) {
                if (!mode.value.equalsIgnoreCase(text)) continue;
                return mode;
            }
            return ALWAYS;
        }
    }

    private static class RestrictionListEntry
    extends Button {
        private final String restrictionName;
        private final Consumer<String> onSelected;

        public RestrictionListEntry(int x, int y, int width, int height, String restrictionName, Consumer<String> onSelected) {
            super(x, y, width, height, (Component)Component.m_237113_((String)restrictionName), button -> {}, f_252438_);
            this.restrictionName = restrictionName;
            this.onSelected = onSelected;
        }

        public void m_5691_() {
            super.m_5691_();
            this.onSelected.accept(this.restrictionName);
        }
    }
}

