/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages.client.screens;

import com.decursioteam.decursio_stages.DecursioStages;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RestrictItemContainer
implements Container {
    private static final int CONTAINER_SIZE = 54;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
    @Nullable
    private List<ContainerListener> listeners;

    public void addListener(ContainerListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public int m_6643_() {
        return 54;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < 54; ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public List<ItemStack> getAllItems() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < 54; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            result.add(stack.m_41777_());
        }
        return result;
    }

    public ItemStack m_8020_(int slot) {
        if (slot >= 0 && slot < 54) {
            return (ItemStack)this.items.get(slot);
        }
        DecursioStages.LOGGER.warn("RestrictItemContainer: Attempted to get item from invalid slot {}", (Object)slot);
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (slot >= 0 && slot < 54) {
            ItemStack result = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
            if (!result.m_41619_()) {
                this.m_6596_();
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        if (slot >= 0 && slot < 54) {
            ItemStack result = (ItemStack)this.items.get(slot);
            this.items.set(slot, (Object)ItemStack.f_41583_);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < 54) {
            this.items.set(slot, (Object)stack);
            if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        } else {
            DecursioStages.LOGGER.warn("RestrictItemContainer: Attempted to set item in invalid slot {}", (Object)slot);
        }
    }

    public void m_6596_() {
        if (this.listeners != null) {
            for (ContainerListener listener : this.listeners) {
                listener.m_5757_((Container)this);
            }
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < 54; ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        this.m_6596_();
    }
}

