/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.decursio_stages;

import com.decursioteam.decursio_stages.DecursioStages;
import com.decursioteam.decursio_stages.datagen.RestrictionsData;
import com.decursioteam.decursio_stages.datagen.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="decursio_stages")
public class Registry {
    public static final Gson GSON = new Gson();
    private static final Set<String> RESTRICTIONS = new HashSet<String>();

    public static Set<String> getRestrictionsHashSet() {
        return new HashSet<String>(RESTRICTIONS);
    }

    public static Set<String> getRestrictions() {
        return RESTRICTIONS;
    }

    public static void clearRestrictions() {
        RESTRICTIONS.clear();
    }

    public static void registerRestrictionsList() {
        RestrictionsData.getRegistry().getRestrictions().forEach((name, data) -> Registry.registerRestrictions(name));
    }

    public static void registerRestrictions(String name) {
        Registry.getRestrictions().add(name);
    }

    public static void setupRestrictions() {
        DecursioStages.LOGGER.info("Loading restrictions...");
        Registry.clearRestrictions();
        RestrictionsData.getRegistry().clearRawRestrictionsData();
        RestrictionsData.getRegistry().clearCustomRestrictionData();
        FileUtils.streamFilesAndParse(Registry.createCustomPath("restrictions"), Registry::parseRestriction, "Could not stream restrictions!");
        RestrictionsData.getRegistry().regenerateCustomRestrictionData();
    }

    private static void parseRestriction(Reader reader, String name) {
        JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
        name = (String)Codec.STRING.fieldOf("name").orElse((Object)name).codec().fieldOf("Restriction Data").codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).get().orThrow();
        RestrictionsData.getRegistry().cacheRawRestrictionsData(name.toLowerCase(Locale.ENGLISH).replace(" ", "_"), jsonObject);
    }

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "decursio_stages", pathName);
        Registry.createDirectory(customPath, pathName);
        return customPath;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            DecursioStages.LOGGER.error("failed to create \"{}\" directory", (Object)dirName);
        }
    }
}

