/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.events;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.message.CrowWhitelistSyncToServer;
import net.joefoxe.hexerei.util.message.PlayerWhitelistingForCrowSyncToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CrowWhitelistEvent {
    public static CrowEntity whiteListingCrow = null;
    public static boolean pressed = false;
    public static List<Player> playersActivelyWhitelisting = new ArrayList<Player>();

    @SubscribeEvent
    public static void selectBlockPosition(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && whiteListingCrow != null && (whiteListingCrow.m_21224_() || whiteListingCrow.m_146911_() == Entity.RemovalReason.DISCARDED || whiteListingCrow.m_146911_() == Entity.RemovalReason.KILLED)) {
            HexereiPacketHandler.sendToServer(new PlayerWhitelistingForCrowSyncToServer(false));
            whiteListingCrow = null;
        }
    }

    @SubscribeEvent
    public static void selectBlockPosition(InputEvent.Key event) {
    }

    @SubscribeEvent
    public static void selectBlockPosition(InputEvent.MouseButton event) {
        if (event.getButton() == 1 && event.getAction() == 0) {
            pressed = false;
        }
    }

    @SubscribeEvent
    public static void logIn(PlayerEvent.PlayerLoggedInEvent event) {
        playersActivelyWhitelisting.remove(event.getEntity());
    }

    @SubscribeEvent
    public static void logOut(PlayerEvent.PlayerLoggedOutEvent event) {
        playersActivelyWhitelisting.remove(event.getEntity());
    }

    @SubscribeEvent
    public static void selectBlockPosition(PlayerInteractEvent.RightClickBlock event) {
        AttachedStemBlock stemBlock;
        Block block;
        BlockState state;
        if (!event.getLevel().f_46443_ && playersActivelyWhitelisting.contains(event.getEntity())) {
            state = event.getLevel().m_8055_(event.getPos());
            block = state.m_60734_();
            if (block instanceof AttachedStemBlock) {
                stemBlock = (AttachedStemBlock)block;
                block = stemBlock.f_48831_;
            }
            if (block.m_49966_().m_204336_(HexereiTags.Blocks.CROW_HARVESTABLE) || block.m_49966_().m_204336_(HexereiTags.Blocks.CROW_BLOCK_HARVESTABLE)) {
                event.setUseBlock(Event.Result.DENY);
                event.getEntity().m_6674_(InteractionHand.MAIN_HAND);
            }
        }
        if (event.getLevel().f_46443_) {
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                if (whiteListingCrow != null) {
                    if (!pressed) {
                        state = event.getLevel().m_8055_(event.getPos());
                        block = state.m_60734_();
                        if (block instanceof AttachedStemBlock) {
                            stemBlock = (AttachedStemBlock)block;
                            block = stemBlock.f_48831_;
                        }
                        if (block.m_49966_().m_204336_(HexereiTags.Blocks.CROW_HARVESTABLE) || block.m_49966_().m_204336_(HexereiTags.Blocks.CROW_BLOCK_HARVESTABLE)) {
                            if (!CrowWhitelistEvent.whiteListingCrow.harvestWhitelist.contains(block)) {
                                CrowWhitelistEvent.whiteListingCrow.harvestWhitelist.add(block);
                                pressed = true;
                                ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                                if (loc != null) {
                                    event.getEntity().m_6674_(InteractionHand.MAIN_HAND);
                                    HexereiPacketHandler.sendToServer(new CrowWhitelistSyncToServer((Entity)whiteListingCrow, CrowWhitelistEvent.whiteListingCrow.harvestWhitelist));
                                    CrowWhitelistEvent.spawnWhitelistParticles(event.getLevel(), event.getPos(), true);
                                    CrowWhitelistEvent.spawnWhitelistCrowParticle(event.getLevel(), whiteListingCrow, true);
                                }
                            } else {
                                CrowWhitelistEvent.whiteListingCrow.harvestWhitelist.remove(block);
                                pressed = true;
                                event.getEntity().m_6674_(InteractionHand.MAIN_HAND);
                                HexereiPacketHandler.sendToServer(new CrowWhitelistSyncToServer((Entity)whiteListingCrow, CrowWhitelistEvent.whiteListingCrow.harvestWhitelist));
                                CrowWhitelistEvent.spawnWhitelistParticles(event.getLevel(), event.getPos(), false);
                                CrowWhitelistEvent.spawnWhitelistCrowParticle(event.getLevel(), whiteListingCrow, false);
                            }
                            event.setUseBlock(Event.Result.DENY);
                        }
                    } else {
                        event.setUseBlock(Event.Result.DENY);
                    }
                }
            } else {
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    public static void spawnParticlesOnBlockFaces(Level p_216314_, BlockPos p_216315_, ParticleOptions p_216316_, IntProvider p_216317_, boolean whitelisted) {
        RandomSource randomSource = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            CrowWhitelistEvent.spawnParticlesOnBlockFace(randomSource, p_216315_, p_216316_, p_216317_, direction, () -> CrowWhitelistEvent.getRandomSpeedRanges(randomSource), 0.55, whitelisted);
        }
    }

    public static void spawnParticlesOnBlockFace(RandomSource randomSource, BlockPos p_216320_, ParticleOptions p_216321_, IntProvider p_216322_, Direction p_216323_, Supplier<Vec3> p_216324_, double p_216325_, boolean whitelisted) {
        int i = p_216322_.m_214085_(randomSource);
        for (int j = 0; j < i; ++j) {
            CrowWhitelistEvent.spawnParticleOnFace(randomSource, p_216320_, p_216323_, p_216321_, p_216324_.get(), p_216325_, whitelisted);
        }
    }

    private static Vec3 getRandomSpeedRanges(RandomSource p_216303_) {
        return new Vec3(Mth.m_216263_((RandomSource)p_216303_, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)p_216303_, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)p_216303_, (double)-0.5, (double)0.5));
    }

    public static void spawnParticleOnFace(RandomSource randomSource, BlockPos p_216308_, Direction p_216309_, ParticleOptions p_216310_, Vec3 p_216311_, double p_216312_, boolean whitelisted) {
        double d5;
        double d4;
        double d3;
        int k;
        double d2;
        int j;
        double d1;
        ParticleEngine pe = Minecraft.m_91087_().f_91061_;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)p_216308_);
        int i = p_216309_.m_122429_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_216263_((RandomSource)randomSource, (double)-0.5, (double)0.5) : (double)i * p_216312_);
        Particle p = pe.m_107370_(p_216310_, d0, d1 = vec3.f_82480_ + ((j = p_216309_.m_122430_()) == 0 ? Mth.m_216263_((RandomSource)randomSource, (double)-0.5, (double)0.5) : (double)j * p_216312_), d2 = vec3.f_82481_ + ((k = p_216309_.m_122431_()) == 0 ? Mth.m_216263_((RandomSource)randomSource, (double)-0.5, (double)0.5) : (double)k * p_216312_), (d3 = i == 0 ? p_216311_.m_7096_() : 0.0) / 200.0, (d4 = j == 0 ? p_216311_.m_7098_() : 0.0) / 200.0, (d5 = k == 0 ? p_216311_.m_7094_() : 0.0) / 200.0);
        if (p != null) {
            p.m_107257_(20);
            p.m_107253_(0.55f, 0.1f, 0.1f);
            if (whitelisted) {
                p.m_107253_(0.1f, 0.5f, 0.1f);
            }
        }
    }

    public static void spawnWhitelistParticles(Level worldIn, BlockPos pos, boolean whitelisted) {
        SimpleParticleType basicparticletype = ParticleTypes.f_175830_;
        CrowWhitelistEvent.spawnParticlesOnBlockFaces(worldIn, pos, (ParticleOptions)basicparticletype, (IntProvider)UniformInt.m_146622_((int)3, (int)5), whitelisted);
    }

    public static void spawnWhitelistCrowParticle(Level worldIn, CrowEntity crow, boolean whitelisted) {
        RandomSource random = crow.m_217043_();
        SimpleParticleType basicparticletype = ParticleTypes.f_175830_;
        ParticleEngine pe = Minecraft.m_91087_().f_91061_;
        Vec3 offset = new Vec3(0.0, 0.0, 0.0);
        Particle p = pe.m_107370_((ParticleOptions)basicparticletype, crow.m_20185_() + offset.f_82479_, crow.m_20186_() + random.m_188500_() * (double)0.15f, crow.m_20189_() + offset.f_82481_, 0.0, random.m_188500_() * 0.1 + 0.15, 0.0);
        if (p != null) {
            p.m_107257_(20);
            p.m_107253_(0.55f, 0.1f, 0.1f);
            if (whitelisted) {
                p.m_107253_(0.1f, 0.5f, 0.1f);
            }
        }
    }
}

