/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.WoodcutterRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodcutterRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final int ingredient_count;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private final String type;

    public WoodcutterRecipeBuilder(ItemLike ingredient, ItemLike result, int count, int ingredient_count, String type) {
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        this.result = result.m_5456_();
        this.count = count;
        this.ingredient_count = ingredient_count;
        this.type = type;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("give_recipe", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{this.ingredient.m_43908_()[0].m_41720_()}).m_45077_()})).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15978_);
        String path = "recipes/" + pRecipeId.m_135815_();
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.result, this.count, this.ingredient_count, this.ingredient, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), path.trim()), this.type));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final Ingredient ingredient;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        public final int ingredientCount;
        public final String type;

        public Result(ResourceLocation pId, Item pResult, int pCount, int ingredientCount, Ingredient ingredient, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, String type) {
            this.ingredientCount = ingredientCount;
            this.id = pId;
            this.result = pResult;
            this.count = pCount;
            this.ingredient = ingredient;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
            this.type = type;
        }

        public void m_7917_(JsonObject pJson) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_()).toString());
            pJson.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            pJson.add("ingredient", (JsonElement)jsonobject);
            if (this.count > 1) {
                pJson.addProperty("count", (Number)this.count);
            }
            if (this.ingredientCount > 1) {
                pJson.addProperty("ingredient_count", (Number)this.ingredientCount);
            }
        }

        public ResourceLocation m_6445_() {
            return new ResourceLocation("hexerei", "woodcutting/" + this.type + "/" + ForgeRegistries.ITEMS.getKey((Object)this.result).m_135815_() + "_from_" + ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_()).m_135815_() + "_woodcutting");
        }

        public RecipeSerializer<?> m_6637_() {
            return WoodcutterRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

