/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.holder;

import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.endec.Endec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record HolderProperty<T>(String name, Endec<T> endec, BiConsumer<AccessoriesHolder, T> setter, Function<AccessoriesHolder, T> getter) {
    public static final Endec<HolderProperty<?>> ENDEC = Endec.STRING.xmap(HolderProperty::getProperty, HolderProperty::name);
    private static final Map<String, HolderProperty<?>> ALL_PROPERTIES = new HashMap();
    public static HolderProperty<Boolean> LINES_PROP;
    public static HolderProperty<Boolean> COSMETIC_PROP;
    public static HolderProperty<Boolean> UNUSED_PROP;
    public static HolderProperty<Boolean> UNIQUE_PROP;
    public static HolderProperty<PlayerEquipControl> EQUIP_CONTROL;

    public HolderProperty(String name, Endec<T> endec, BiConsumer<AccessoriesHolder, T> setter, Function<AccessoriesHolder, T> getter) {
        ALL_PROPERTIES.put(name, this);
        this.name = name;
        this.endec = endec;
        this.setter = setter;
        this.getter = getter;
    }

    public static HolderProperty<?> getProperty(String name) {
        HolderProperty<?> prop;
        if (ALL_PROPERTIES.isEmpty()) {
            HolderProperty.init();
        }
        if ((prop = ALL_PROPERTIES.get(name)) == null) {
            throw new IllegalStateException("Unable to locate the given HolderProperty! [Name: " + name + "]");
        }
        return prop;
    }

    public void setData(Player player, Object data) {
        AccessoriesInternals.modifyHolder((LivingEntity)player, holder -> {
            this.setter.accept((AccessoriesHolder)holder, (AccessoriesHolder)data);
            return holder;
        });
    }

    public <V> V consumeData(Player player, BiFunction<HolderProperty<T>, T, V> biFunction) {
        T data = this.getter().apply(player.accessoriesHolder());
        return biFunction.apply(this, (HolderProperty)data);
    }

    public static void init() {
        if (!ALL_PROPERTIES.isEmpty()) {
            return;
        }
        LINES_PROP = new HolderProperty<Boolean>("lines", Endec.BOOLEAN, AccessoriesHolder::linesShown, AccessoriesHolder::linesShown);
        COSMETIC_PROP = new HolderProperty<Boolean>("cosmetic", Endec.BOOLEAN, AccessoriesHolder::cosmeticsShown, AccessoriesHolder::cosmeticsShown);
        UNUSED_PROP = new HolderProperty<Boolean>("unused_slots", Endec.BOOLEAN, AccessoriesHolder::showUnusedSlots, AccessoriesHolder::showUnusedSlots);
        UNIQUE_PROP = new HolderProperty<Boolean>("unique_slots", Endec.BOOLEAN, AccessoriesHolder::showUniqueSlots, AccessoriesHolder::showUniqueSlots);
        EQUIP_CONTROL = new HolderProperty<PlayerEquipControl>("equip_control", Endec.forEnum(PlayerEquipControl.class), AccessoriesHolder::equipControl, AccessoriesHolder::equipControl);
    }

    static {
        HolderProperty.init();
    }
}

