/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.endec.format.nbt;

import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.RecursiveSerializer;
import io.wispforest.endec.util.VarInts;
import java.util.Optional;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtSerializer
extends RecursiveSerializer<Tag>
implements SelfDescribedSerializer<Tag> {
    protected Tag prefix;

    protected NbtSerializer(Tag prefix) {
        super((Object)EndTag.f_128534_);
        this.prefix = prefix;
    }

    public static NbtSerializer of(Tag prefix) {
        return new NbtSerializer(prefix);
    }

    public static NbtSerializer of() {
        return NbtSerializer.of(null);
    }

    public void writeByte(SerializationContext ctx, byte value) {
        this.consume(ByteTag.m_128266_((byte)value));
    }

    public void writeShort(SerializationContext ctx, short value) {
        this.consume(ShortTag.m_129258_((short)value));
    }

    public void writeInt(SerializationContext ctx, int value) {
        this.consume(IntTag.m_128679_((int)value));
    }

    public void writeLong(SerializationContext ctx, long value) {
        this.consume(LongTag.m_128882_((long)value));
    }

    public void writeFloat(SerializationContext ctx, float value) {
        this.consume(FloatTag.m_128566_((float)value));
    }

    public void writeDouble(SerializationContext ctx, double value) {
        this.consume(DoubleTag.m_128500_((double)value));
    }

    public void writeVarInt(SerializationContext ctx, int value) {
        this.consume(switch (VarInts.getSizeInBytesFromInt((int)value)) {
            case 0, 1 -> ByteTag.m_128266_((byte)((byte)value));
            case 2 -> ShortTag.m_129258_((short)((short)value));
            default -> IntTag.m_128679_((int)value);
        });
    }

    public void writeVarLong(SerializationContext ctx, long value) {
        this.consume(switch (VarInts.getSizeInBytesFromLong((long)value)) {
            case 0, 1 -> ByteTag.m_128266_((byte)((byte)value));
            case 2 -> ShortTag.m_129258_((short)((short)value));
            case 3, 4 -> IntTag.m_128679_((int)((int)value));
            default -> LongTag.m_128882_((long)value);
        });
    }

    public void writeBoolean(SerializationContext ctx, boolean value) {
        this.consume(ByteTag.m_128273_((boolean)value));
    }

    public void writeString(SerializationContext ctx, String value) {
        this.consume(StringTag.m_129297_((String)value));
    }

    public void writeBytes(SerializationContext ctx, byte[] bytes) {
        this.consume(new ByteArrayTag(bytes));
    }

    public <V> void writeOptional(SerializationContext ctx, Endec<V> endec, Optional<V> optional) {
        if (this.isWritingStructField()) {
            optional.ifPresent(v -> endec.encode(ctx, (Serializer)this, v));
        } else {
            try (Serializer.Struct struct = this.struct();){
                struct.field("present", ctx, Endec.BOOLEAN, (Object)optional.isPresent());
                optional.ifPresent(value -> struct.field("value", ctx, endec, value));
            }
        }
    }

    public <E> Serializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec, int size) {
        return new Sequence<E>(ctx, elementEndec);
    }

    public <V> Serializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec, int size) {
        return new Map<V>(ctx, valueEndec);
    }

    public Serializer.Struct struct() {
        return new Map(null, null);
    }

    private class Sequence<V>
    implements Serializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final ListTag result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Sequence(SerializationContext ctx, Endec<V> valueEndec) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (NbtSerializer.this.prefix != null) {
                ListTag prefixList;
                Tag tag = NbtSerializer.this.prefix;
                if (!(tag instanceof ListTag)) throw new IllegalStateException("Incompatible prefix of type " + NbtSerializer.this.prefix.getClass().getSimpleName() + " provided for NBT sequence");
                this.result = prefixList = (ListTag)tag;
                return;
            } else {
                this.result = new ListTag();
            }
        }

        public void element(V element) {
            NbtSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)NbtSerializer.this, element);
                this.result.add((Object)((Tag)encoded.require("sequence element")));
            }, false);
        }

        public void end() {
            NbtSerializer.this.consume(this.result);
        }
    }

    private class Map<V>
    implements Serializer.Map<V>,
    Serializer.Struct {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final CompoundTag result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map(SerializationContext ctx, Endec<V> valueEndec) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (NbtSerializer.this.prefix != null) {
                CompoundTag prefixMap;
                Tag tag = NbtSerializer.this.prefix;
                if (!(tag instanceof CompoundTag)) throw new IllegalStateException("Incompatible prefix of type " + NbtSerializer.this.prefix.getClass().getSimpleName() + " provided for NBT map/struct");
                this.result = prefixMap = (CompoundTag)tag;
                return;
            } else {
                this.result = new CompoundTag();
            }
        }

        public void entry(String key, V value) {
            NbtSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)NbtSerializer.this, value);
                this.result.m_128365_(key, (Tag)encoded.require("map value"));
            }, false);
        }

        public <F> Serializer.Struct field(String name, SerializationContext ctx, Endec<F> endec, F value) {
            NbtSerializer.this.frame(encoded -> {
                endec.encode(ctx, (Serializer)NbtSerializer.this, value);
                if (encoded.wasEncoded()) {
                    this.result.m_128365_(name, (Tag)encoded.get());
                }
            }, true);
            return this;
        }

        public void end() {
            NbtSerializer.this.consume(this.result);
        }
    }
}

