/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.Window;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.AccessoriesInternalsClient;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.ClientLifecycleEvents;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import java.util.Collection;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class AccessoriesClient {
    public static final ResourceLocation BLIT_SHADER_ID = Accessories.of("fish");
    public static ShaderInstance BLIT_SHADER;
    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT;
    public static boolean IS_PLAYER_INVISIBLE;
    private static boolean displayUnusedSlotWarning;

    public static void init() {
        AccessoriesInternalsClient.registerToMenuTypes();
        Accessories.CONFIG_HOLDER.registerSaveListener((manager, data) -> {
            AccessoriesClient.handleConfigChangesSync(data);
            return InteractionResult.SUCCESS;
        });
        Accessories.CONFIG_HOLDER.registerLoadListener((manager, data) -> {
            AccessoriesClient.handleConfigChangesSync(data);
            return InteractionResult.SUCCESS;
        });
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) {
                return;
            }
            AccessoriesRendererRegistry.onReload();
        });
    }

    public static void handleConfigChangesSync(AccessoriesConfig config) {
        LocalPlayer currentPlayer = Minecraft.m_91087_().f_91074_;
        if (currentPlayer == null || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        AccessoriesHolder holder = currentPlayer.accessoriesHolder();
        if (holder == null) {
            return;
        }
        if (holder.showUniqueSlots() && !config.clientData.showUniqueRendering) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNIQUE_PROP, false));
        }
        if (holder.equipControl() != config.clientData.equipControl) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.EQUIP_CONTROL, config.clientData.equipControl));
        }
        if (holder.showUnusedSlots() != config.clientData.showUnusedSlots) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, config.clientData.showUnusedSlots));
        }
    }

    public static boolean attemptToOpenScreen() {
        return AccessoriesClient.attemptToOpenScreen(false);
    }

    public static boolean attemptToOpenScreen(boolean targetingLookingEntity) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (targetingLookingEntity) {
            LivingEntity living;
            EntityHitResult entityHitResult;
            Entity entity;
            boolean bl;
            HitResult result = ProjectileUtil.m_278180_((Entity)player, e -> e instanceof LivingEntity, (double)(player.m_7500_() ? 4.5 : 4.0));
            boolean bl2 = bl = !(result instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) || EntitySlotLoader.getEntitySlots(living = (LivingEntity)entity).isEmpty();
            if (bl) {
                return false;
            }
            AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(true));
        } else {
            Collection<SlotType> slots = AccessoriesAPI.getUsedSlotsFor((Player)player);
            AccessoriesHolder holder = player.accessoriesHolder();
            if (holder == null) {
                return false;
            }
            if (slots.isEmpty() && !holder.showUnusedSlots() && !displayUnusedSlotWarning && !Accessories.getConfig().clientData.disableEmptySlotScreenError) {
                player.m_5661_((Component)Component.m_237113_((String)"[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);
                displayUnusedSlotWarning = true;
            }
            AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(false));
        }
        return true;
    }

    static {
        WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
            for (WindowResizeCallback callback : callbacks) {
                callback.onResized(client, window);
            }
        });
        IS_PLAYER_INVISIBLE = false;
        displayUnusedSlotWarning = false;
    }

    public static interface WindowResizeCallback {
        public void onResized(Minecraft var1, Window var2);
    }
}

