/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import net.minecraft.util.RandomSource;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TumblingAnimation {
    private float speedX;
    private float speedY;
    private float speedZ;
    private final Quaternionf currentOrientation = new Quaternionf().identity();
    private final Quaternionf previousOrientation = new Quaternionf().identity();
    private boolean initialized = false;
    private final float minAngularVelMag;
    private final float maxAngularVelMag;
    private final float jitterAmount;

    public TumblingAnimation(float minMagnitude, float maxMagnitude, float maxJitterAmount) {
        this.minAngularVelMag = minMagnitude;
        this.maxAngularVelMag = maxMagnitude;
        this.jitterAmount = maxJitterAmount;
    }

    private void initRotationSpeeds(RandomSource rand) {
        float z;
        float y;
        float x = rand.m_188501_() * 2.0f - 1.0f;
        float length = (float)Math.sqrt(x * x + (y = rand.m_188501_() * 2.0f - 1.0f) * y + (z = rand.m_188501_() * 2.0f - 1.0f) * z);
        if ((double)length < 1.0E-6) {
            x = 1.0f;
            y = 0.0f;
            z = 0.0f;
            length = 1.0f;
        }
        float magnitude = this.minAngularVelMag + rand.m_188501_() * (this.maxAngularVelMag - this.minAngularVelMag);
        this.speedX = (x /= length) * magnitude;
        this.speedY = (y /= length) * magnitude;
        this.speedZ = (z /= length) * magnitude;
    }

    public void tick(RandomSource rand) {
        if (!this.initialized) {
            this.initRotationSpeeds(rand);
            this.initialized = true;
        }
        this.speedX += (rand.m_188501_() - 0.5f) * this.jitterAmount;
        this.speedY += (rand.m_188501_() - 0.5f) * this.jitterAmount;
        this.speedZ += (rand.m_188501_() - 0.5f) * this.jitterAmount;
        float mag = (float)Math.sqrt(this.speedX * this.speedX + this.speedY * this.speedY + this.speedZ * this.speedZ);
        if (mag < this.minAngularVelMag) {
            scale = this.minAngularVelMag / mag;
            this.speedX *= scale;
            this.speedY *= scale;
            this.speedZ *= scale;
            mag = this.minAngularVelMag;
        } else if (mag > this.maxAngularVelMag) {
            scale = this.maxAngularVelMag / mag;
            this.speedX *= scale;
            this.speedY *= scale;
            this.speedZ *= scale;
            mag = this.maxAngularVelMag;
        }
        this.previousOrientation.set((Quaternionfc)this.currentOrientation);
        if (mag < 1.0E-6f) {
            return;
        }
        float angleRad = (float)Math.toRadians(mag);
        float axisX = this.speedX / mag;
        float axisY = this.speedY / mag;
        float axisZ = this.speedZ / mag;
        Quaternionf deltaQ = new Quaternionf().fromAxisAngleRad(axisX, axisY, axisZ, angleRad);
        this.currentOrientation.set((Quaternionfc)deltaQ.mul((Quaternionfc)this.currentOrientation));
        this.currentOrientation.normalize();
    }

    public Quaternionf getRotation(float partialTicks) {
        if (!this.initialized) {
            return new Quaternionf().identity();
        }
        return this.previousOrientation.nlerp((Quaternionfc)this.currentOrientation, partialTicks, new Quaternionf());
    }
}

