/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.stat.descriptive.moment;

import com.happysg.radar.math3.exception.MathIllegalArgumentException;
import com.happysg.radar.math3.exception.MathIllegalStateException;
import com.happysg.radar.math3.exception.NullArgumentException;
import com.happysg.radar.math3.exception.util.LocalizedFormats;
import com.happysg.radar.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import com.happysg.radar.math3.stat.descriptive.StorelessUnivariateStatistic;
import com.happysg.radar.math3.stat.descriptive.summary.SumOfLogs;
import com.happysg.radar.math3.util.FastMath;
import com.happysg.radar.math3.util.MathUtils;
import java.io.Serializable;

public class GeometricMean
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -8178734905303459453L;
    private StorelessUnivariateStatistic sumOfLogs;

    public GeometricMean() {
        this.sumOfLogs = new SumOfLogs();
    }

    public GeometricMean(GeometricMean original) throws NullArgumentException {
        GeometricMean.copy(original, this);
    }

    public GeometricMean(SumOfLogs sumOfLogs) {
        this.sumOfLogs = sumOfLogs;
    }

    @Override
    public GeometricMean copy() {
        GeometricMean result = new GeometricMean();
        GeometricMean.copy(this, result);
        return result;
    }

    @Override
    public void increment(double d) {
        this.sumOfLogs.increment(d);
    }

    @Override
    public double getResult() {
        if (this.sumOfLogs.getN() > 0L) {
            return FastMath.exp(this.sumOfLogs.getResult() / (double)this.sumOfLogs.getN());
        }
        return Double.NaN;
    }

    @Override
    public void clear() {
        this.sumOfLogs.clear();
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return FastMath.exp(this.sumOfLogs.evaluate(values, begin, length) / (double)length);
    }

    @Override
    public long getN() {
        return this.sumOfLogs.getN();
    }

    public void setSumLogImpl(StorelessUnivariateStatistic sumLogImpl) throws MathIllegalStateException {
        this.checkEmpty();
        this.sumOfLogs = sumLogImpl;
    }

    public StorelessUnivariateStatistic getSumLogImpl() {
        return this.sumOfLogs;
    }

    public static void copy(GeometricMean source, GeometricMean dest) throws NullArgumentException {
        MathUtils.checkNotNull(source);
        MathUtils.checkNotNull(dest);
        dest.setData(source.getDataRef());
        dest.sumOfLogs = source.sumOfLogs.copy();
    }

    private void checkEmpty() throws MathIllegalStateException {
        if (this.getN() > 0L) {
            throw new MathIllegalStateException(LocalizedFormats.VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, this.getN());
        }
    }
}

