/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.dsvv.cbcat.cannon.RifledBarrelBlockEntity;
import com.dsvv.cbcat.cannon.heavy_autocannon.IHeavyAutocannonBlockEntity;
import com.dsvv.cbcat.cannon.heavy_autocannon.contraption.MountedHeavyAutocannonContraption;
import com.dsvv.cbcat.cannon.twin_autocannon.ITwinAutocannonBlockEntity;
import com.dsvv.cbcat.cannon.twin_autocannon.contraption.MountedTwinAutocannonContraption;
import com.happysg.radar.compat.Mods;
import com.happysg.radar.mixin.AbstractCannonAccessor;
import com.happysg.radar.mixin.AutoCannonAccessor;
import com.mojang.logging.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedAutocannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedBigCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.IAutocannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterial;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialProperties;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import riftyboi.cbcmodernwarfare.cannon_control.compact_mount.CompactCannonMountBlock;
import riftyboi.cbcmodernwarfare.cannon_control.compact_mount.CompactCannonMountBlockEntity;
import riftyboi.cbcmodernwarfare.cannon_control.contraption.MountedMediumcannonContraption;
import riftyboi.cbcmodernwarfare.cannon_control.contraption.MountedRotarycannonContraption;
import riftyboi.cbcmodernwarfare.cannons.medium_cannon.MediumcannonBlock;
import riftyboi.cbcmodernwarfare.cannons.medium_cannon.MediumcannonBlockEntity;
import riftyboi.cbcmodernwarfare.cannons.medium_cannon.breech.MediumcannonBreechBlockEntity;
import riftyboi.cbcmodernwarfare.cannons.medium_cannon.material.MediumcannonMaterial;
import riftyboi.cbcmodernwarfare.cannons.rotarycannon.RotarycannonBlock;
import riftyboi.cbcmodernwarfare.cannons.rotarycannon.RotarycannonBlockEntity;
import riftyboi.cbcmodernwarfare.cannons.rotarycannon.material.RotarycannonMaterial;
import riftyboi.cbcmodernwarfare.forge.cannons.RotarycannonBreechBlockEntity;

public class CannonUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static int getBarrelLength(AbstractMountedCannonContraption cannon) {
        if (cannon == null) {
            return 0;
        }
        if (cannon.initialOrientation() == Direction.WEST || cannon.initialOrientation() == Direction.NORTH) {
            return ((AbstractCannonAccessor)cannon).getBackExtensionLength();
        }
        return ((AbstractCannonAccessor)cannon).getFrontExtensionLength();
    }

    public static Vec3 getCannonMountOffset(Level level, BlockPos pos) {
        return CannonUtil.getCannonMountOffset(level.m_7702_(pos));
    }

    public static Vec3 getCannonMountOffset(BlockEntity mount) {
        Vec3 offset = null;
        if (Mods.CBCMODERNWARFARE.isLoaded() && mount instanceof CompactCannonMountBlockEntity) {
            Direction direction = (Direction)mount.m_58900_().m_61143_((Property)CompactCannonMountBlock.HORIZONTAL_FACING);
            if (direction == Direction.EAST) {
                offset = new Vec3(0.0, 0.0, 1.0);
            } else if (direction == Direction.SOUTH) {
                offset = new Vec3(-1.0, 0.0, 0.0);
            } else if (direction == Direction.WEST) {
                offset = new Vec3(0.0, 0.0, -1.0);
            } else if (direction == Direction.NORTH) {
                offset = new Vec3(1.0, 0.0, 0.0);
            }
        } else {
            offset = CannonUtil.isUp(mount) ? new Vec3(0.0, 2.0, 0.0) : new Vec3(0.0, -2.0, 0.0);
        }
        return offset;
    }

    public static float getRotarySpeed(AbstractMountedCannonContraption contraptionEntity) {
        if (!Mods.CBCMODERNWARFARE.isLoaded()) {
            return 0.0f;
        }
        if (contraptionEntity == null) {
            return 0.0f;
        }
        Map presentBlockEntities = contraptionEntity.entity.getContraption().presentBlockEntities;
        LOGGER.debug(" \u2192 presentBlockEntities count = {}", (Object)presentBlockEntities.size());
        if (presentBlockEntities.isEmpty()) {
            return 0.0f;
        }
        int barrelCount = 0;
        RotarycannonMaterial material = null;
        List blocks = presentBlockEntities.values().stream().toList();
        for (BlockEntity entity : blocks) {
            if (!(entity instanceof RotarycannonBlockEntity)) continue;
            RotarycannonBlockEntity blockEntity = (RotarycannonBlockEntity)entity;
            if (entity instanceof RotarycannonBreechBlockEntity) continue;
            ++barrelCount;
            if (material != null) continue;
            material = ((RotarycannonBlock)blockEntity.m_58900_().m_60734_()).getRotarycannonMaterial();
        }
        if (material == null) {
            return 0.0f;
        }
        float baseSpeed = material.properties().baseSpeed();
        int speedIncrease = Math.min(barrelCount, material.properties().maxSpeedIncreases());
        return baseSpeed + (float)speedIncrease * material.properties().speedIncreasePerBarrel();
    }

    public static float getMediumCannonSpeed(AbstractMountedCannonContraption contraptionEntity) {
        if (!Mods.CBCMODERNWARFARE.isLoaded()) {
            return 0.0f;
        }
        if (contraptionEntity == null) {
            return 0.0f;
        }
        Map presentBlockEntities = contraptionEntity.entity.getContraption().presentBlockEntities;
        if (presentBlockEntities.isEmpty()) {
            return 0.0f;
        }
        int barrelCount = 0;
        MediumcannonMaterial material = null;
        List blocks = presentBlockEntities.values().stream().toList();
        for (BlockEntity entity : blocks) {
            if (!(entity instanceof MediumcannonBlockEntity)) continue;
            MediumcannonBlockEntity blockEntity = (MediumcannonBlockEntity)entity;
            if (entity instanceof MediumcannonBreechBlockEntity) continue;
            ++barrelCount;
            if (material != null) continue;
            material = ((MediumcannonBlock)blockEntity.m_58900_().m_60734_()).getMediumcannonMaterial();
        }
        if (material == null) {
            return 0.0f;
        }
        float baseSpeed = material.properties().baseSpeed();
        int speedIncrease = Math.min(barrelCount, material.properties().maxSpeedIncreases());
        return baseSpeed + (float)speedIncrease * material.properties().speedIncreasePerBarrel();
    }

    public static int getBigCannonSpeed(ServerLevel level, PitchOrientedContraptionEntity contraptionEntity) {
        if (contraptionEntity == null) {
            return 0;
        }
        Map presentBlockEntities = contraptionEntity.getContraption().presentBlockEntities;
        int speeed = 0;
        for (BlockEntity blockEntity : presentBlockEntities.values()) {
            if (!(blockEntity instanceof IBigCannonBlockEntity)) continue;
            IBigCannonBlockEntity cannonBlockEntity = (IBigCannonBlockEntity)blockEntity;
            BigCannonBehavior behavior = (BigCannonBehavior)cannonBlockEntity.cannonBehavior();
            StructureTemplate.StructureBlockInfo containedBlockInfo = behavior.block();
            Block block = containedBlockInfo.f_74676_().m_60734_();
            if (block instanceof BigCannonPropellantBlock) {
                BigCannonPropellantBlock propellantBlock = (BigCannonPropellantBlock)block;
                speeed += (int)propellantBlock.getChargePower(containedBlockInfo);
                continue;
            }
            if (!(block instanceof ProjectileBlock)) continue;
            ProjectileBlock projectileBlock = (ProjectileBlock)block;
            AbstractBigCannonProjectile projectile = projectileBlock.getProjectile((Level)level, Collections.singletonList(containedBlockInfo));
            speeed += (int)projectile.addedChargePower();
        }
        return speeed;
    }

    public static float getInitialVelocity(AbstractMountedCannonContraption cannon, ServerLevel level) {
        LOGGER.debug("\u2192 getInitialVelocity for contraption={} mods: BigCannon={}, AutoCannon={}, Rotary={}, Medium={}", new Object[]{cannon.getClass().getSimpleName(), CannonUtil.isBigCannon(cannon), CannonUtil.isAutoCannon(cannon), CannonUtil.isRotaryCannon(cannon), CannonUtil.isMediumCannon(cannon)});
        if (CannonUtil.isBigCannon(cannon)) {
            LOGGER.debug("   \u2022 BigCannon speed = {}", (Object)CannonUtil.getBigCannonSpeed(level, (PitchOrientedContraptionEntity)cannon.entity));
            return CannonUtil.getBigCannonSpeed(level, (PitchOrientedContraptionEntity)cannon.entity);
        }
        if (CannonUtil.isAutoCannon(cannon)) {
            LOGGER.debug("   \u2022 AutoCannon speed = {}", (Object)Float.valueOf(CannonUtil.getAutoCannonSpeed(cannon)));
            return CannonUtil.getAutoCannonSpeed(cannon);
        }
        if (CannonUtil.isRotaryCannon(cannon)) {
            LOGGER.debug("   \u2022 RotaryCannon speed = {}", (Object)Float.valueOf(CannonUtil.getRotarySpeed(cannon)));
            return CannonUtil.getRotarySpeed(cannon);
        }
        if (CannonUtil.isMediumCannon(cannon)) {
            LOGGER.debug("   \u2022 MediumCannon speed = {}", (Object)Float.valueOf(CannonUtil.getMediumCannonSpeed(cannon)));
            return CannonUtil.getMediumCannonSpeed(cannon);
        }
        if (CannonUtil.isTwinAutocannon(cannon)) {
            LOGGER.debug("   \u2022 TwinACannon speed = {}", (Object)Float.valueOf(CannonUtil.getAutoCannonSpeed(cannon)));
            return CannonUtil.getAutoCannonSpeed(cannon);
        }
        if (CannonUtil.isHeavyAutocannon(cannon)) {
            LOGGER.debug("   \u2022 HeavyACannon speed = {}", (Object)Float.valueOf(CannonUtil.getAutoCannonSpeed(cannon)));
            return CannonUtil.getAutoCannonSpeed(cannon);
        }
        LOGGER.debug("   \u2022 No known cannon type \u2192 returning 0");
        return 0.0f;
    }

    public static double getProjectileGravity(AbstractMountedCannonContraption cannon, ServerLevel level) {
        if (CannonUtil.isAutoCannon(cannon) || CannonUtil.isRotaryCannon(cannon) || CannonUtil.isMediumCannon(cannon) || CannonUtil.isTwinAutocannon(cannon) || CannonUtil.isHeavyAutocannon(cannon)) {
            return -0.025;
        }
        Map presentBlockEntities = cannon.presentBlockEntities;
        for (BlockEntity blockEntity : presentBlockEntities.values()) {
            BallisticPropertiesComponent ballisticProperties;
            IBigCannonBlockEntity cannonBlockEntity;
            BigCannonBehavior behavior;
            StructureTemplate.StructureBlockInfo containedBlockInfo;
            Block block;
            if (!(blockEntity instanceof IBigCannonBlockEntity) || !((block = (containedBlockInfo = (behavior = (BigCannonBehavior)(cannonBlockEntity = (IBigCannonBlockEntity)blockEntity).cannonBehavior()).block()).f_74676_().m_60734_()) instanceof ProjectileBlock)) continue;
            ProjectileBlock projectileBlock = (ProjectileBlock)block;
            AbstractBigCannonProjectile projectile = projectileBlock.getProjectile((Level)level, Collections.singletonList(containedBlockInfo));
            try {
                Method method = projectile.getClass().getDeclaredMethod("getBallisticProperties", new Class[0]);
                method.setAccessible(true);
                ballisticProperties = (BallisticPropertiesComponent)method.invoke((Object)projectile, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return 0.05;
            }
            return ballisticProperties.gravity();
        }
        return 0.05;
    }

    public static double getProjectileDrag(AbstractMountedCannonContraption cannon, ServerLevel level) {
        Map presentBlockEntities = cannon.presentBlockEntities;
        double drag = 0.01;
        int rifledBarrelAmount = 0;
        for (BlockEntity blockEntity : presentBlockEntities.values()) {
            BallisticPropertiesComponent ballisticProperties;
            BigCannonBehavior behavior;
            StructureTemplate.StructureBlockInfo containedBlockInfo;
            Block block;
            if (!(blockEntity instanceof IBigCannonBlockEntity)) continue;
            IBigCannonBlockEntity cannonBlockEntity = (IBigCannonBlockEntity)blockEntity;
            if (Mods.CBC_AT.isLoaded() && blockEntity instanceof RifledBarrelBlockEntity) {
                ++rifledBarrelAmount;
            }
            if (!((block = (containedBlockInfo = (behavior = (BigCannonBehavior)cannonBlockEntity.cannonBehavior()).block()).f_74676_().m_60734_()) instanceof ProjectileBlock)) continue;
            ProjectileBlock projectileBlock = (ProjectileBlock)block;
            AbstractBigCannonProjectile projectile = projectileBlock.getProjectile((Level)level, Collections.singletonList(containedBlockInfo));
            try {
                Method method = projectile.getClass().getDeclaredMethod("getBallisticProperties", new Class[0]);
                method.setAccessible(true);
                ballisticProperties = (BallisticPropertiesComponent)method.invoke((Object)projectile, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return drag;
            }
            drag = ballisticProperties.drag();
        }
        return drag;
    }

    public static boolean isHeavyAutocannon(AbstractMountedCannonContraption cannon) {
        if (!Mods.CBC_AT.isLoaded()) {
            return false;
        }
        return cannon instanceof MountedHeavyAutocannonContraption;
    }

    public static boolean isTwinAutocannon(AbstractMountedCannonContraption cannon) {
        if (!Mods.CBC_AT.isLoaded()) {
            return false;
        }
        return cannon instanceof MountedTwinAutocannonContraption;
    }

    public static boolean isBigCannon(AbstractMountedCannonContraption cannon) {
        return cannon instanceof MountedBigCannonContraption;
    }

    public static boolean isAutoCannon(AbstractMountedCannonContraption cannon) {
        return cannon instanceof MountedAutocannonContraption;
    }

    public static boolean isRotaryCannon(AbstractMountedCannonContraption cannonContraption) {
        if (!Mods.CBCMODERNWARFARE.isLoaded()) {
            return false;
        }
        return cannonContraption instanceof MountedRotarycannonContraption;
    }

    public static boolean isMediumCannon(AbstractMountedCannonContraption cannonContraption) {
        if (!Mods.CBCMODERNWARFARE.isLoaded()) {
            return false;
        }
        return cannonContraption instanceof MountedMediumcannonContraption;
    }

    private static float getAutoCannonSpeed(AbstractMountedCannonContraption cannon) {
        BlockEntity be;
        AutocannonMaterial cann = ((AutoCannonAccessor)cannon).getMaterial();
        if (cann == null) {
            return 0.0f;
        }
        AutocannonMaterialProperties props = cann.properties();
        Predicate<BlockEntity> isBarrel = null;
        if (cannon instanceof MountedAutocannonContraption) {
            isBarrel = e -> e instanceof IAutocannonBlockEntity;
        } else if (cannon instanceof MountedTwinAutocannonContraption) {
            isBarrel = e -> e instanceof ITwinAutocannonBlockEntity;
        } else if (cannon instanceof MountedHeavyAutocannonContraption) {
            isBarrel = e -> e instanceof IHeavyAutocannonBlockEntity;
        }
        float speed = props.baseSpeed();
        BlockPos pos = cannon.getStartPos().m_121945_(cannon.initialOrientation());
        int count = 0;
        while (isBarrel.test(be = (BlockEntity)cannon.presentBlockEntities.get(pos))) {
            if (++count <= props.maxSpeedIncreases()) {
                speed += props.speedIncreasePerBarrel();
            }
            if (count > props.maxBarrelLength()) break;
            pos = pos.m_121945_(cannon.initialOrientation());
        }
        return speed;
    }

    public static boolean isUp(Level level, Vec3 mountPos) {
        BlockEntity blockEntity = level.m_7702_(new BlockPos((int)mountPos.f_82479_, (int)mountPos.f_82480_, (int)mountPos.f_82481_));
        return CannonUtil.isUp(blockEntity);
    }

    public static boolean isUp(BlockEntity blockEntity) {
        if (!(blockEntity instanceof CannonMountBlockEntity)) {
            return true;
        }
        CannonMountBlockEntity cannonMountBlockEntity = (CannonMountBlockEntity)blockEntity;
        if (cannonMountBlockEntity.getContraption() == null) {
            return true;
        }
        return !(cannonMountBlockEntity.getContraption().m_20182_().f_82480_ < (double)blockEntity.m_58899_().m_123342_());
    }
}

