/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CollectionUtil {
    public static <E> Enumeration<E> asEnumeration(final Iterator<E> iter) {
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public E nextElement() {
                return iter.next();
            }
        };
    }

    public static <E> Iterator<E> asIterator(final Enumeration<E> e) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Collection<T> collectionOf(Iterator<? extends T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> Stream<T> streamOf(Iterator<T> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false);
    }

    public static <T> Stream<T> streamOf(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> parallelStreamOf(Iterator<T> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), true);
    }

    public static <T> Stream<T> parallelStreamOf(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), true);
    }
}

