/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.http.upload;

import com.hypherionmc.simplerpc.jodd.http.HttpException;
import com.hypherionmc.simplerpc.jodd.http.upload.Uploadable;
import com.hypherionmc.simplerpc.jodd.io.FileNameUtil;
import com.hypherionmc.simplerpc.jodd.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUploadable
implements Uploadable<File> {
    protected final File file;
    protected final String fileName;
    protected final String mimeType;

    public FileUploadable(File file) {
        this.file = file;
        this.fileName = FileNameUtil.getName(file.getName());
        this.mimeType = null;
    }

    public FileUploadable(File file, String fileName, String mimeType) {
        this.file = file;
        this.fileName = fileName;
        this.mimeType = mimeType;
    }

    @Override
    public File getContent() {
        return this.file;
    }

    @Override
    public byte[] getBytes() {
        try {
            return FileUtil.readBytes(this.file);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getSize() {
        return (int)this.file.length();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

