/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network.messages;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.network.Message;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageShowSulfuricFluxEmitterStatus
implements Message {
    private List<SulfuricFluxEmitterSelectedPoint> sourcePedestals;
    private SulfuricFluxEmitterSelectedPoint targetPedestal;
    private SulfuricFluxEmitterSelectedPoint resultPedestal;
    private BlockPos blockPos;

    public MessageShowSulfuricFluxEmitterStatus(BlockPos blockPos, List<SulfuricFluxEmitterSelectedPoint> sourcePedestals, SulfuricFluxEmitterSelectedPoint targetPedestal, SulfuricFluxEmitterSelectedPoint resultPedestal) {
        this.blockPos = blockPos;
        this.sourcePedestals = sourcePedestals;
        this.targetPedestal = targetPedestal;
        this.resultPedestal = resultPedestal;
    }

    public MessageShowSulfuricFluxEmitterStatus(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.m_236828_(this.sourcePedestals, (buf1, point) -> buf1.m_272073_(point.codec(), point));
        buf.m_236821_((Object)this.targetPedestal, (buf1, point) -> buf1.m_272073_(point.codec(), point));
        buf.m_236821_((Object)this.resultPedestal, (buf1, point) -> buf1.m_272073_(point.codec(), point));
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.sourcePedestals = buf.m_236845_(buf1 -> (SulfuricFluxEmitterSelectedPoint)buf1.m_271872_(SulfuricFluxEmitterSelectedPoint.CODEC));
        this.targetPedestal = (SulfuricFluxEmitterSelectedPoint)buf.m_236868_(buf1 -> (SulfuricFluxEmitterSelectedPoint)buf1.m_271872_(SulfuricFluxEmitterSelectedPoint.CODEC));
        this.resultPedestal = (SulfuricFluxEmitterSelectedPoint)buf.m_236868_(buf1 -> (SulfuricFluxEmitterSelectedPoint)buf1.m_271872_(SulfuricFluxEmitterSelectedPoint.CODEC));
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player, NetworkEvent.Context context) {
        BlockEntity blockEntity;
        Level level = player.m_9236_();
        this.sourcePedestals.forEach(point -> point.setLevel(level));
        if (this.targetPedestal != null) {
            this.targetPedestal.setLevel(level);
        }
        if (this.resultPedestal != null) {
            this.resultPedestal.setLevel(level);
        }
        if ((blockEntity = level.m_7702_(this.blockPos)) instanceof SulfuricFluxEmitterBlockEntity) {
            SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter = (SulfuricFluxEmitterBlockEntity)blockEntity;
            sulfuricFluxEmitter.setSelectedPointsClient(this.sourcePedestals, this.targetPedestal, this.resultPedestal);
        }
        ((SulfuricFluxEmitterBlock)((Object)BlockRegistry.SULFURIC_FLUX_EMITTER.get())).interactionBehaviour().showStatus(level, this.blockPos, player);
    }
}

