/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;

public class DigestionRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 200;

    public DigestionRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "digestion");
    }

    public void makeTierConversion(AlchemicalSulfurItem lower, AlchemicalSulfurItem higher, int conversionFactor, int salAmmoniacAmount) {
        this.makeRecipe((Fluid)FluidRegistry.SAL_AMMONIAC.get(), salAmmoniacAmount, List.of(Pair.of((Object)((Object)lower), (Object)conversionFactor), Pair.of((Object)((Item)ItemRegistry.PURIFIED_GOLD.get()), (Object)1)), higher, 1, 1000, "_from_" + lower.tier().name().toLowerCase());
        this.makeRecipe((Fluid)FluidRegistry.SAL_AMMONIAC.get(), salAmmoniacAmount, List.of(Pair.of((Object)((Object)higher), (Object)1)), lower, conversionFactor, 1000, "_from_" + higher.tier().name().toLowerCase());
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.makeRecipeWithTags((Fluid)Fluids.f_76193_, 1000, List.of(Tags.Items.INGOTS_GOLD, ItemTagRegistry.ALCHEMICAL_SALTS), (Item)ItemRegistry.PURIFIED_GOLD.get(), 20, 1000);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), 4, 10);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), 4, 15);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()), 4, 50);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), 4, 10);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), 4, 15);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()), 4, 50);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), 4, 10);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), 4, 15);
        this.makeTierConversion((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()), 4, 50);
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<Pair<Item, Integer>> ingredients, Item result, int resultCount, int time, String postFix) {
        this.makeRecipe(this.name(result) + postFix, fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(Fluid fluid, int fluidAmount, List<Pair<Item, Integer>> ingredients, Item result, int resultCount, int time) {
        this.makeRecipe(this.name(result), fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipe(String name, Fluid fluid, int fluidAmount, List<Pair<Item, Integer>> ingredients, Item result, int resultCount, int time) {
        JsonObject recipe = this.makeRecipeJson(this.makeFluidTagIngredient(this.locFor(fluid)), fluidAmount, ingredients.stream().map(i -> this.makeItemIngredient(this.locFor((ItemLike)i.getFirst()), (Integer)i.getSecond())).toList(), this.makeItemStackCodecResult(this.locFor((ItemLike)result), resultCount), time);
        this.recipeConsumer.accept(this.modLoc(name), recipe);
    }

    public void makeRecipeWithTags(Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        this.makeRecipeWithTags(this.name(result), fluid, fluidAmount, ingredients, result, resultCount, time);
    }

    public void makeRecipeWithTags(String name, Fluid fluid, int fluidAmount, List<TagKey<Item>> ingredients, Item result, int resultCount, int time) {
        JsonObject recipe = this.makeRecipeJson(this.makeFluidTagIngredient(this.locFor(fluid)), fluidAmount, ingredients.stream().map(i -> this.makeTagIngredient(this.locFor((TagKey<Item>)i), 1)).toList(), this.makeItemStackCodecResult(this.locFor((ItemLike)result), resultCount), time);
        JsonArray conditions = new JsonArray();
        for (TagKey<Item> ingredient : ingredients) {
            conditions.add((JsonElement)this.makeTagNotEmptyCondition(ingredient.f_203868_().toString()));
        }
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeConsumer.accept(this.modLoc(name), recipe);
    }

    public JsonObject makeRecipeJson(JsonObject fluid, int fluidAmount, List<JsonObject> ingredients, JsonObject result, int time) {
        JsonArray ingredientsArray = new JsonArray();
        for (JsonObject ingredient : ingredients) {
            ingredientsArray.add((JsonElement)ingredient);
        }
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.DIGESTION.getId().toString());
        recipe.add("fluid", (JsonElement)fluid);
        recipe.addProperty("fluidAmount", (Number)fluidAmount);
        recipe.add("ingredients", (JsonElement)ingredientsArray);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("time", (Number)time);
        return recipe;
    }

    public String m_6055_() {
        return "Digestion Recipes";
    }
}

