/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.spagyrics;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.SaltRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class OreRefiningEntry
extends EntryProvider {
    public static final String ENTRY_ID = "ore_refining";

    public OreRefiningEntry(CategoryProvider parent) {
        super(parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Spagyrics for Refining");
        this.pageText("The easiest application of Spagyrics is the refining of ores and raw metals. The process of smelting metal in a furnace is wasteful, as it only yields a single ingot per ore, losing a lot of the precious raw materials in the process. Alchemists can extract even the last iota of value from ores, but the process is somewhat more complex.\n");
        this.page("intro2", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Ore Duplication");
        this.pageText("The first application of Spagyrics thus we will be the efficient refining of raw metals into multiple ingots.\nIn the following pages and entries we will attempt to create *three* {0} out of just *one* {1} using Spagyrics processes.\n", new Object[]{this.itemLink("Iron Ingots", (ItemLike)Items.f_42416_), this.itemLink("Raw Iron", (ItemLike)Items.f_151050_)});
        this.page("overview", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("The Process");
        this.pageText("To refine an Ore or Raw Metal you first need to {0} it, which will yield multiple Metal Sulfur. Additionally you need to obtain multiple heaps of {1} to provide a body for this multiplied Sulfur, and some {2} to provide the mercury for the soul of the resulting refined ingots.\n", new Object[]{this.entryLink("liquefy", "apparatus", "liquefaction_cauldron"), this.itemLink("Mineral Salt", (ItemLike)SaltRegistry.MINERAL.get()), this.itemLink("Mercury Shards", (ItemLike)ItemRegistry.MERCURY_SHARD.get())});
        this.page("next", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("How?");
        this.pageText("The next entries will guide you through the process of obtaining all the materials and creating your iron ingots.\n");
    }

    protected String entryName() {
        return "Ore Refining";
    }

    protected String entryDescription() {
        return "Triple your ore yield";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ResourceLocation)Theurgy.loc("textures/gui/book/raw_metal_x3.png"), (int)32, (int)32);
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

