/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.apparatus.reformation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class ReformationArrayEntry
extends EntryProvider {
    public static final String ENTRY_ID = "reformation_array";

    public ReformationArrayEntry(CategoryProvider parent) {
        super(parent);
    }

    protected void generatePages() {
        this.page("about", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Reformation Array");
        this.pageText("Reformation is the process of converting sulfurs into other Sulfurs of the same type and tier (such as common gems to common gems).\\\nFurther, it can be used to convert between different types of Niters of the same tier, and to convert Niters into Sulfurs.\nThe reformation array provides the necessary framework to perform this process.\n");
        this.page("about2", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.pageTitle("Reformation Array");
        this.pageText("The reformation array provides the necessary framework to perform this process.\n");
        this.page("structure", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.add(this.context().pageTitle(), "Structure");
        this.add(this.context().pageText(), "The array has no fixed structure, you simply need to place a {0}, at least one {1}, and a {2} within a few blocks of each other.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get()), this.itemLink((ItemLike)ItemRegistry.MERCURY_CATALYST.get())});
        this.page("structure2", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.add(this.context().pageTitle(), "Structure");
        this.add(this.context().pageText(), "To set up the array, right-click each of the pedestals with the {3} to link it. Finally place the {3} near the pedestals and supply it with mercury flux, e.g. by attaching it to a {4}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get()), this.entryLink("Sulfuric Flux Emitter", "apparatus", "sulfuric_flux_emitter"), this.itemLink((ItemLike)ItemRegistry.MERCURY_CATALYST.get())});
        this.page("functions", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.add(this.context().pageTitle(), "Functions");
        this.add(this.context().pageText(), "- {0} will hold the sulfur you want to create more of.\n- {1} will hold the input sulfur you want to use up. Multiple may be required.\n- {2} will be filled with the created sulfur.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get()), this.itemLink((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get())});
        this.page("placement", () -> BookMultiblockPageModel.builder().withMultiblockId(Theurgy.loc("placement/reformation_array")).withText(this.context().pageText()).build());
        this.add(this.context().pageText(), "An example setup for a Reformation Array. Note that other placements are possible.\n");
        this.page("visuals", () -> BookTextPageModel.builder().withTitle(this.context().pageTitle()).withText(this.context().pageText()).build());
        this.add(this.context().pageTitle(), "Visuals");
        this.add(this.context().pageText(), "A glowing orb will show above a pedestal if it contains sulfur.\\\nFlux particles will fly from the Emitter to the Pedestals if the array is active.\n");
    }

    protected String entryName() {
        return "Reformation Array";
    }

    protected String entryDescription() {
        return "Conversion of Sulfur into other Sulfurs of the same type";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return Pair.of((Object)0, (Object)2);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ResourceLocation)Theurgy.loc("textures/gui/book/convert_sulfur.png"), (int)64, (int)64);
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

