/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe.result;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.klikli_dev.theurgy.content.recipe.result.ItemRecipeResult;
import com.klikli_dev.theurgy.content.recipe.result.TagRecipeResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;

public abstract class RecipeResult {
    public static RecipeResult fromJson(JsonObject json) {
        if (json.has("item")) {
            return new ItemRecipeResult(CraftingHelper.getItemStack((JsonObject)json, (boolean)true, (boolean)true));
        }
        if (json.has("tag")) {
            return (RecipeResult)TagRecipeResult.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().get();
        }
        throw new JsonParseException("RecipeResult must have either an \"tag\" or \"item\" field.");
    }

    public static RecipeResult fromNetwork(FriendlyByteBuf pBuffer) {
        byte type = pBuffer.readByte();
        if (type == ItemRecipeResult.TYPE) {
            return ItemRecipeResult.fromNetwork(pBuffer);
        }
        if (type == TagRecipeResult.TYPE) {
            return TagRecipeResult.fromNetwork(pBuffer);
        }
        throw new IllegalArgumentException("Unknown recipe result type: " + type);
    }

    public abstract ItemStack getStack();

    public abstract ItemStack[] getStacks();

    public abstract byte getType();

    public void toNetwork(FriendlyByteBuf pBuffer) {
        pBuffer.writeByte((int)this.getType());
    }
}

