/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour;

import com.klikli_dev.theurgy.util.TetraConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StorageBehaviour<S extends StorageBehaviour<?>> {
    protected BlockEntity blockEntity;
    protected List<LazyOptional<?>> capabilities;
    protected TetraConsumer<IItemHandler, Integer, ItemStack, ItemStack> onContentTypeChanged;
    protected BiConsumer<IItemHandler, Integer> onContentsChanged;
    protected Consumer<IFluidHandler> onFluidContentsChanged;

    public StorageBehaviour(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.capabilities = new ArrayList();
    }

    protected void onContentsChanged(IItemHandler handler, int slot) {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.accept(handler, slot);
        }
    }

    protected void onContentTypeChanged(IItemHandler handler, int slot, ItemStack oldStack, ItemStack newStack) {
        if (this.onContentTypeChanged != null) {
            this.onContentTypeChanged.accept(handler, slot, oldStack, newStack);
        }
    }

    protected void onFluidContentsChanged(IFluidHandler handler) {
        if (this.onFluidContentsChanged != null) {
            this.onFluidContentsChanged.accept(handler);
        }
    }

    public S withOnContentTypeChanged(TetraConsumer<IItemHandler, Integer, ItemStack, ItemStack> onContentTypeChanged) {
        this.onContentTypeChanged = onContentTypeChanged;
        return (S)this;
    }

    public S withOnContentsChanged(BiConsumer<IItemHandler, Integer> onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
        return (S)this;
    }

    public S onFluidContentsChanged(Consumer<IFluidHandler> onFluidContentsChanged) {
        this.onFluidContentsChanged = onFluidContentsChanged;
        return (S)this;
    }

    public abstract void readNetwork(CompoundTag var1);

    public abstract void writeNetwork(CompoundTag var1);

    public abstract void saveAdditional(CompoundTag var1);

    public abstract void load(CompoundTag var1);

    @NotNull
    public abstract <T> LazyOptional<T> getCapability(@NotNull Capability<T> var1, @Nullable Direction var2);

    protected void register(LazyOptional<?> capability) {
        this.capabilities.add(capability);
    }

    public void invalidateCaps() {
        this.capabilities.forEach(LazyOptional::invalidate);
    }

    protected void sendBlockUpdated() {
        if (this.blockEntity.m_58904_() != null && !this.blockEntity.m_58904_().f_46443_) {
            this.blockEntity.m_58904_().m_7260_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_(), this.blockEntity.m_58900_(), 2);
        }
    }

    protected void setChanged() {
        this.blockEntity.m_6596_();
    }
}

