/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour;

import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class HeatConsumerBehaviour {
    private final BlockEntity blockEntity;
    int CHECK_HEAT_TICK_INTERVAL = 20;
    private boolean heatedCache;

    public HeatConsumerBehaviour(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    boolean hasHeatProvider() {
        BlockEntity below = this.blockEntity.m_58904_().m_7702_(this.blockEntity.m_58899_().m_7495_());
        if (below == null) {
            return false;
        }
        return below.getCapability(CapabilityRegistry.HEAT_PROVIDER, Direction.UP).map(provider -> provider.isHot()).orElse(false);
    }

    public boolean isHeated() {
        if (this.blockEntity.m_58904_().m_46467_() % (long)this.CHECK_HEAT_TICK_INTERVAL == 0L) {
            HeatReceiver heatReceiver;
            boolean wasHeated = this.heatedCache;
            boolean isHeated = this.hasHeatProvider();
            if (!isHeated && (heatReceiver = (HeatReceiver)this.blockEntity.getCapability(CapabilityRegistry.HEAT_RECEIVER).orElse(null)) != null) {
                isHeated = heatReceiver.getIsHotUntil() > this.blockEntity.m_58904_().m_46467_();
            }
            this.heatedCache = isHeated;
            if (wasHeated != isHeated) {
                if (this.blockEntity.m_58900_().m_61138_((Property)BlockStateProperties.f_61443_)) {
                    BlockState newState = (BlockState)this.blockEntity.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isHeated));
                    this.blockEntity.m_58904_().m_7731_(this.blockEntity.m_58899_(), newState, 3);
                }
                this.blockEntity.m_6596_();
            }
        }
        return this.heatedCache;
    }
}

