/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron;

import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class LiquefactionCraftingBehaviour
extends CraftingBehaviour<RecipeWrapperWithFluid, LiquefactionRecipe, LiquefactionCachedCheck> {
    protected Supplier<IFluidHandler> solventTankSupplier;

    public LiquefactionCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> solventTankSupplier) {
        super(blockEntity, Lazy.of(() -> new RecipeWrapperWithFluid((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)solventTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new LiquefactionCachedCheck((RecipeType<LiquefactionRecipe>)((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get())));
        this.solventTankSupplier = solventTankSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        return ((LiquefactionCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.m_58904_()).isPresent();
    }

    @Override
    protected int getIngredientCount(LiquefactionRecipe recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(LiquefactionRecipe recipe) {
        return recipe.getLiquefactionTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    protected boolean craft(LiquefactionRecipe pRecipe) {
        if (!super.craft(pRecipe)) {
            return false;
        }
        this.solventTankSupplier.get().drain(pRecipe.getSolventAmount(), IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

