/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.teleport;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.network.packets.TeleportFadeS2C;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.speed.SpeedHandler;
import net.rasanovum.viaromana.util.EffectUtils;

public class ServerTeleportHandler {
    private static final Map<UUID, Node> activeTeleports = new ConcurrentHashMap<UUID, Node>();
    private static final Map<UUID, Long> teleportStartTimes = new ConcurrentHashMap<UUID, Long>();
    private static final int FADE_UP_TICKS = 20;
    private static final int HOLD_TICKS = 10;
    private static final int FADE_DOWN_TICKS = 20;
    private static final int FOOTSTEP_INTERVAL = 7;
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final double RANGE_WIDTH = 0.4;
    private static final double RANGE_MIN = 0.3;

    public static boolean isTeleporting(ServerPlayer player) {
        return activeTeleports.containsKey(player.m_20148_());
    }

    public static void tick(ServerLevel level) {
        long currentTime = level.m_46467_();
        activeTeleports.forEach((playerUUID, targetNode) -> {
            Long startTime = teleportStartTimes.get(playerUUID);
            if (startTime == null) {
                return;
            }
            long elapsedTicks = currentTime - startTime;
            ServerPlayer player = level.m_7654_().m_6846_().m_11259_(playerUUID);
            if (elapsedTicks == 20L) {
                if (player != null && player.m_6084_()) {
                    ServerTeleportHandler.executeTeleportation(player, targetNode);
                    EffectUtils.applyEffect((Entity)player, "travellers_fatigue");
                }
            } else if (elapsedTicks == 50L) {
                activeTeleports.remove(playerUUID);
                teleportStartTimes.remove(playerUUID);
            }
        });
    }

    public static void handleTeleportRequest(TeleportRequestC2S packet, ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        PathGraph graph = PathGraph.getInstance(level);
        graph.getNodeAt(packet.destinationPos()).ifPresent(targetNode -> {
            activeTeleports.put(player.m_20148_(), (Node)targetNode);
            teleportStartTimes.put(player.m_20148_(), level.m_46467_());
            PacketBroadcaster.S2C.sendToPlayer((Packet)new TeleportFadeS2C(20, 10, 20, 7), player);
        });
    }

    private static void executeTeleportation(ServerPlayer player, Node targetNode) {
        BlockPos centerPos;
        BlockPos randomizedCenter;
        if (!player.m_6084_()) {
            return;
        }
        ServerLevel level = player.m_284548_();
        BlockPos safePos = ServerTeleportHandler.findSafePosition(level, randomizedCenter = (centerPos = BlockPos.m_122022_((long)targetNode.getPos())).m_7918_(RANDOM.m_188503_(3) - 1, 0, RANDOM.m_188503_(3) - 1));
        if (safePos == null) {
            player.m_5661_((Component)Component.m_237115_((String)"message.via_romana.unsafe"), true);
            activeTeleports.remove(player.m_20148_());
            return;
        }
        double x = (double)safePos.m_123341_() + RANDOM.m_188500_() * 0.4 + 0.3;
        double y = ServerTeleportHandler.getAccurateYPosition(level, safePos);
        double z = (double)safePos.m_123343_() + RANDOM.m_188500_() * 0.4 + 0.3;
        Entity rootVehicle = player.m_20201_();
        if (rootVehicle != player && !ServerTeleportHandler.isValidTeleportEntity(rootVehicle)) {
            player.m_8127_();
            rootVehicle = player;
        }
        SpeedHandler.resetState(player);
        ServerTeleportHandler.teleportStack(rootVehicle, level, x, y, z);
    }

    private static void teleportStack(Entity rootEntity, ServerLevel level, double x, double y, double z) {
        HashMap passengerMap = new HashMap();
        ArrayList<Entity> allEntities = new ArrayList<Entity>();
        ArrayList<Object> toProcess = new ArrayList<Object>();
        toProcess.add(rootEntity);
        while (!toProcess.isEmpty()) {
            Entity current = (Entity)toProcess.remove(0);
            allEntities.add(current);
            List passengers = List.copyOf(current.m_20197_());
            if (passengers.isEmpty()) continue;
            passengerMap.put(current, passengers);
            toProcess.addAll(passengers);
        }
        rootEntity.m_20153_();
        HashMap<Entity, Entity> newEntityMap = new HashMap<Entity, Entity>();
        for (Entity oldEntity : allEntities) {
            Entity newEntity = ServerTeleportHandler.recreateAndTeleportEntity(oldEntity, level, x, y, z);
            if (newEntity == null) continue;
            newEntityMap.put(oldEntity, newEntity);
        }
        if (!passengerMap.isEmpty()) {
            level.m_7654_().m_6937_((Runnable)new TickTask(3, () -> passengerMap.forEach((oldVehicle, oldPassengers) -> {
                Entity newVehicle = (Entity)newEntityMap.get(oldVehicle);
                if (newVehicle != null && newVehicle.m_6084_()) {
                    oldPassengers.forEach(oldPassenger -> {
                        Entity newPassenger = (Entity)newEntityMap.get(oldPassenger);
                        if (newPassenger != null && newPassenger.m_6084_()) {
                            newPassenger.m_7998_(newVehicle, true);
                        }
                    });
                }
            })));
        }
    }

    private static Entity recreateAndTeleportEntity(Entity oldEntity, ServerLevel level, double x, double y, double z) {
        if (oldEntity.m_213877_()) {
            return null;
        }
        if (oldEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)oldEntity;
            player.m_8999_(level, x, y, z, player.m_146908_(), player.m_146909_());
            player.f_19789_ = 0.0f;
            return player;
        }
        Entity newEntity = oldEntity.m_6095_().m_20615_((Level)level);
        if (newEntity == null) {
            return null;
        }
        CompoundTag nbt = oldEntity.m_20240_(new CompoundTag());
        nbt.m_128473_("Passengers");
        nbt.m_128473_("UUID");
        newEntity.m_20258_(nbt);
        newEntity.m_7678_(x, y, z, oldEntity.m_146908_(), oldEntity.m_146909_());
        level.m_7967_(newEntity);
        oldEntity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        return newEntity;
    }

    private static BlockPos findSafePosition(ServerLevel level, BlockPos center) {
        int dx = 0;
        while (dx <= 1) {
            int dz = 0;
            while (dz <= 1) {
                BlockPos checkPos = center.m_7918_(dx, 0, dz);
                if (!ServerTeleportHandler.isHole(level, checkPos)) {
                    return checkPos;
                }
                dz = dz > 0 ? -dz : -dz + 1;
            }
            dx = dx > 0 ? -dx : -dx + 1;
        }
        return null;
    }

    private static boolean isHole(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            BlockPos checkPos = pos.m_6625_(i);
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60795_() || state.m_60742_((BlockGetter)level, checkPos, CollisionContext.m_82749_()).m_83281_()) continue;
            return false;
        }
        return true;
    }

    private static double getAccurateYPosition(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            BlockPos groundPos = pos.m_6625_(i);
            BlockState groundState = level.m_8055_(groundPos);
            VoxelShape shape = groundState.m_60742_((BlockGetter)level, groundPos, CollisionContext.m_82749_());
            if (shape.m_83281_()) continue;
            return (double)groundPos.m_123342_() + shape.m_83297_(Direction.Axis.Y);
        }
        return (double)pos.m_123342_() + 1.0;
    }

    private static boolean isValidTeleportEntity(Entity entity) {
        String entityType = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString();
        return !CommonConfig.invalid_entities.contains(entityType);
    }
}

