/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.level;

import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.level.ServerLevelTrackedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class LevelCornerTrackedData
extends ServerLevelTrackedData {
    private final Map<String, byte[]> cornerMap = new HashMap<String, byte[]>();

    public LevelCornerTrackedData(TrackedDataKey<? extends ServerLevelTrackedData> trackedDataKey, ServerLevel level) {
        super(trackedDataKey, level);
    }

    public CompoundTag save() {
        if (this.cornerMap.isEmpty()) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("corner_map", (Tag)LevelCornerTrackedData.toNBT(this.cornerMap));
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("corner_map")) {
            this.cornerMap.clear();
            this.cornerMap.putAll(LevelCornerTrackedData.fromNBT(tag.m_128469_("corner_map")));
        }
    }

    public void setCornerBytes(ChunkPos pos, byte[] bytes) {
        String key = pos.f_45578_ + "_" + pos.f_45579_;
        if (bytes != null && bytes.length == 4) {
            this.cornerMap.put(key, (byte[])bytes.clone());
        } else {
            this.cornerMap.remove(key);
        }
        this.markDirty();
    }

    public Optional<byte[]> getCornerBytes(ChunkPos pos) {
        String key = pos.f_45578_ + "_" + pos.f_45579_;
        byte[] bytes = this.cornerMap.get(key);
        return bytes != null && bytes.length == 4 ? Optional.of((byte[])bytes.clone()) : Optional.empty();
    }

    private static CompoundTag toNBT(Map<String, byte[]> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            tag.m_128382_(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    private static Map<String, byte[]> fromNBT(CompoundTag tag) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (String key : tag.m_128431_()) {
            map.put(key, tag.m_128463_(key));
        }
        return map;
    }

    public void clearAll() {
        this.cornerMap.clear();
        this.markDirty();
    }
}

