/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.speed;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.StatInit;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;

public class SpeedHandler {
    public static final UUID PROXIMITY_SPEED_ID = UUID.nameUUIDFromBytes("viaromana:node_proximity_speed".getBytes(StandardCharsets.UTF_8));
    public static final String PROXIMITY_SPEED_NAME = "node_proximity_speed";
    private static final double DISTANCE_THRESHOLD = 500000.0;
    private static final Map<UUID, BlockPos> lastPathWalkPositions = new HashMap<UUID, BlockPos>();

    public static void resetState(ServerPlayer player) {
        lastPathWalkPositions.remove(player.m_20148_());
    }

    public static void onPlayerTick(ServerPlayer player) {
        boolean hasModifier;
        if (player.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        if (speedAttribute == null) {
            return;
        }
        boolean nearNode = false;
        PathGraph graph = PathGraph.getInstance((ServerLevel)player.m_9236_());
        if (graph != null) {
            Optional<Node> nearestNode = graph.getNearestNode(player.m_20183_(), CommonConfig.node_distance_minimum);
            nearNode = nearestNode.isPresent();
        }
        boolean bl = hasModifier = speedAttribute.m_22111_(PROXIMITY_SPEED_ID) != null;
        if (nearNode && !hasModifier) {
            AttributeModifier modifier = new AttributeModifier(PROXIMITY_SPEED_ID, PROXIMITY_SPEED_NAME, CommonConfig.fast_movement_speed, AttributeModifier.Operation.MULTIPLY_TOTAL);
            speedAttribute.m_22125_(modifier);
            lastPathWalkPositions.put(player.m_20148_(), player.m_20183_());
        } else if (!nearNode && hasModifier) {
            speedAttribute.m_22120_(PROXIMITY_SPEED_ID);
            lastPathWalkPositions.remove(player.m_20148_());
        } else if (nearNode && hasModifier) {
            BlockPos lastPos = lastPathWalkPositions.get(player.m_20148_());
            BlockPos currentPos = player.m_20183_();
            if (lastPos == null) {
                lastPathWalkPositions.put(player.m_20148_(), currentPos);
            } else if (!lastPos.equals((Object)currentPos)) {
                double distance = Math.sqrt(lastPos.m_123331_((Vec3i)currentPos));
                player.m_6278_(Stats.f_12988_.m_12902_((Object)StatInit.DISTANCE_WALKED), (int)(distance * 100.0));
                lastPathWalkPositions.put(player.m_20148_(), currentPos);
                int totalDistance = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)StatInit.DISTANCE_WALKED));
                if ((double)totalDistance >= 500000.0) {
                    SpeedHandler.awardRunningAdvancement(player);
                }
            }
        }
    }

    private static void awardRunningAdvancement(ServerPlayer player) {
        try {
            AdvancementProgress advancementProgress;
            Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("via_romana:story/i_just_felt_like_running"));
            if (advancement != null && !(advancementProgress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
                for (String c : advancementProgress.m_8219_()) {
                    player.m_8960_().m_135988_(advancement, c);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)"via_romana:story/i_just_felt_like_running", (Object)player.m_7755_().getString(), (Object)e.getMessage());
        }
    }
}

