/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.speed;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.rasanovum.viaromana.speed.SpeedHandler;

public class FieldOfViewHelper {
    public static boolean shouldIgnoreProximitySpeed(Player player) {
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && player.m_150108_()) {
            return false;
        }
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        return attribute != null && attribute.m_22111_(SpeedHandler.PROXIMITY_SPEED_ID) != null;
    }

    public static float getProximityFovCorrection(Player player) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return 1.0f;
        }
        double walkSpeed = player.m_150110_().m_35947_();
        if (walkSpeed == 0.0) {
            return 1.0f;
        }
        double currentSpeed = attribute.m_22135_();
        double cleanSpeed = FieldOfViewHelper.calculateAttributeValueSkipping(attribute);
        float currentFactor = (float)((currentSpeed / walkSpeed + 1.0) / 2.0);
        float cleanFactor = (float)((cleanSpeed / walkSpeed + 1.0) / 2.0);
        if (currentFactor == 0.0f) {
            return 1.0f;
        }
        return cleanFactor / currentFactor;
    }

    private static double calculateAttributeValueSkipping(AttributeInstance attribute) {
        double baseValue = attribute.m_22115_();
        Map<AttributeModifier.Operation, Set> operationToModifiers = Stream.of(AttributeModifier.Operation.values()).collect(Collectors.toMap(op -> op, op -> Sets.newHashSet()));
        for (AttributeModifier modifier : attribute.m_22122_()) {
            if (modifier.m_22209_().equals(SpeedHandler.PROXIMITY_SPEED_ID)) continue;
            operationToModifiers.get(modifier.m_22217_()).add(modifier);
        }
        for (AttributeModifier mod : operationToModifiers.get(AttributeModifier.Operation.ADDITION)) {
            baseValue += mod.m_22218_();
        }
        double value = baseValue;
        for (AttributeModifier mod : operationToModifiers.get(AttributeModifier.Operation.MULTIPLY_BASE)) {
            value += baseValue * mod.m_22218_();
        }
        for (AttributeModifier mod : operationToModifiers.get(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            value *= 1.0 + mod.m_22218_();
        }
        return attribute.m_22099_().m_6740_(value);
    }
}

