/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.path;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.map.ServerMapUtils;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import org.jetbrains.annotations.Nullable;

public final class PathGraph {
    private final ObjectArrayList<Node> nodes = new ObjectArrayList();
    private final Long2IntOpenHashMap posToIndex = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap signPosToIndex = new Long2IntOpenHashMap();
    private final Long2ObjectOpenHashMap<List<Node>> nodesByChunk = new Long2ObjectOpenHashMap();
    private final Map<UUID, NetworkCache> networkCacheById = new HashMap<UUID, NetworkCache>();
    private final Long2ObjectOpenHashMap<UUID> nodeToNetworkId = new Long2ObjectOpenHashMap();
    private final Map<UUID, FoWCache> fowCacheById = new HashMap<UUID, FoWCache>();
    private final Long2ObjectOpenHashMap<Set<UUID>> chunkToNetworkIds = new Long2ObjectOpenHashMap();
    private final LongOpenHashSet dirtyNodePositions = new LongOpenHashSet();
    private static final DyeColor[] NETWORK_COLORS = new DyeColor[]{DyeColor.BLUE, DyeColor.RED, DyeColor.GREEN, DyeColor.PURPLE, DyeColor.CYAN, DyeColor.ORANGE, DyeColor.LIME, DyeColor.PINK, DyeColor.MAGENTA, DyeColor.YELLOW};

    public static PathGraph getInstance(ServerLevel level) {
        return PathDataManager.getOrCreatePathGraph(level);
    }

    public NetworkCache getNetworkCacheForNode(Node startNode) {
        NetworkCache cached;
        UUID networkId = (UUID)this.nodeToNetworkId.get(startNode.getPos());
        if (networkId != null && (cached = this.networkCacheById.get(networkId)) != null) {
            return cached;
        }
        return this.discoverAndCacheNetwork(startNode);
    }

    private NetworkCache discoverAndCacheNetwork(Node startNode) {
        List<Node> networkNodes = this.getNetwork(startNode);
        long[] positionsArr = new long[networkNodes.size()];
        for (int i = 0; i < networkNodes.size(); ++i) {
            positionsArr[i] = networkNodes.get(i).getPos();
        }
        UUID networkId = this.generateDeterministicUUID(positionsArr);
        NetworkCache existingCache = this.networkCacheById.get(networkId);
        if (existingCache != null) {
            this.nodeToNetworkId.put(startNode.getPos(), (Object)networkId);
            this.dirtyNodePositions.remove(startNode.getPos());
            return existingCache;
        }
        BoundingBox bounds = this.calculateBoundsFor(networkNodes);
        List<Node> destinations = networkNodes.stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        LongOpenHashSet positionsSet = new LongOpenHashSet(positionsArr);
        NetworkCache newCache = new NetworkCache(networkId, (LongSet)positionsSet, bounds, destinations);
        this.networkCacheById.put(networkId, newCache);
        for (long pos : positionsArr) {
            this.nodeToNetworkId.put(pos, (Object)networkId);
            this.dirtyNodePositions.remove(pos);
        }
        this.fowCacheById.remove(networkId);
        this.getOrComputeFoWCache(newCache);
        return newCache;
    }

    private void invalidateNetworksContaining(Node ... nodesToInvalidate) {
        for (Node node : nodesToInvalidate) {
            NetworkCache removedCache;
            List<Node> component = this.getNetwork(node);
            if (component.isEmpty()) continue;
            long[] posArr = new long[component.size()];
            for (int i = 0; i < component.size(); ++i) {
                posArr[i] = component.get(i).getPos();
            }
            UUID componentId = this.generateDeterministicUUID(posArr);
            FoWCache fow = this.fowCacheById.get(componentId);
            if (fow != null) {
                this.removeNetworkFromChunkMap(componentId, fow);
            }
            if ((removedCache = this.networkCacheById.remove(componentId)) != null) {
                this.dirtyNodePositions.addAll((LongCollection)removedCache.nodePositions());
            }
            this.fowCacheById.remove(componentId);
            for (Node n : component) {
                this.nodeToNetworkId.remove(n.getPos());
            }
            ServerMapCache.invalidate(componentId);
        }
    }

    private void refreshNetworkDestinations(Node startNode) {
        NetworkCache existing = this.getNetworkCacheForNode(startNode);
        List<Node> destinations = this.getNetwork(startNode).stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        NetworkCache updated = new NetworkCache(existing.id(), existing.nodePositions(), existing.bounds(), destinations);
        this.networkCacheById.put(updated.id(), updated);
    }

    private UUID generateDeterministicUUID(long[] sortedPositions) {
        if (sortedPositions.length == 0) {
            return UUID.randomUUID();
        }
        LongArrays.quickSort((long[])sortedPositions);
        ByteBuffer bb = ByteBuffer.allocate(sortedPositions.length * 8);
        for (long pos : sortedPositions) {
            bb.putLong(pos);
        }
        return UUID.nameUUIDFromBytes(bb.array());
    }

    public DyeColor getNetworkColor(Node node) {
        NetworkCache cache = this.getNetworkCacheForNode(node);
        int colorIndex = Math.abs(cache.id().hashCode() % NETWORK_COLORS.length);
        return NETWORK_COLORS[colorIndex];
    }

    public List<Node> nodesView() {
        return Collections.unmodifiableList(this.nodes);
    }

    public int size() {
        return this.nodes.size();
    }

    public Optional<Node> getNodeAt(BlockPos pos) {
        int idx = this.posToIndex.getOrDefault(pos.m_121878_(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public int getOrCreateNode(BlockPos pos, float quality, float clearance) {
        long packedPos = pos.m_121878_();
        return this.posToIndex.computeIfAbsent(packedPos, k -> {
            int newIndex = this.nodes.size();
            Node newNode = new Node(packedPos, quality, clearance);
            this.nodes.add((Object)newNode);
            long chunkPos = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)pos.m_123341_()), (int)SectionPos.m_123171_((int)pos.m_123343_()));
            ((List)this.nodesByChunk.computeIfAbsent(chunkPos, c -> new ArrayList())).add(newNode);
            this.dirtyNodePositions.add(packedPos);
            return newIndex;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void createConnectedPath(List<Node.NodeData> pathData) {
        void var4_8;
        if (pathData == null || pathData.size() < 2) {
            return;
        }
        ArrayList<Node> pathNodes = new ArrayList<Node>(pathData.size());
        for (Node.NodeData nodeData : pathData) {
            Node currentNode = (Node)this.nodes.get(this.getOrCreateNode(nodeData.pos(), nodeData.quality(), nodeData.clearance()));
            pathNodes.add(currentNode);
        }
        HashSet<UUID> networksToInvalidate = new HashSet<UUID>();
        for (Node node : pathNodes) {
            UUID networkId = (UUID)this.nodeToNetworkId.get(node.getPos());
            if (networkId == null) continue;
            networksToInvalidate.add(networkId);
        }
        for (UUID networkId : networksToInvalidate) {
            NetworkCache cache;
            FoWCache fow = this.fowCacheById.get(networkId);
            if (fow != null) {
                this.removeNetworkFromChunkMap(networkId, fow);
            }
            if ((cache = this.networkCacheById.remove(networkId)) == null) continue;
            this.fowCacheById.remove(networkId);
            this.dirtyNodePositions.addAll((LongCollection)cache.nodePositions());
            for (Long pos : cache.nodePositions()) {
                this.nodeToNetworkId.remove(pos.longValue());
            }
            ServerMapCache.invalidate(networkId);
        }
        boolean bl = true;
        while (var4_8 < pathNodes.size()) {
            ((Node)pathNodes.get((int)(var4_8 - true))).connect((Node)pathNodes.get((int)var4_8));
            ++var4_8;
        }
        for (Node node : pathNodes) {
            this.dirtyNodePositions.add(node.getPos());
        }
    }

    public void createOrUpdatePseudoNetwork(UUID pseudoNetworkId, List<Node.NodeData> tempNodes) {
        if (tempNodes == null || tempNodes.size() < 2) {
            return;
        }
        NetworkCache existing = this.networkCacheById.remove(pseudoNetworkId);
        if (existing != null) {
            FoWCache fow = this.fowCacheById.get(pseudoNetworkId);
            if (fow != null) {
                this.removeNetworkFromChunkMap(pseudoNetworkId, fow);
            }
            LongIterator longIterator = existing.nodePositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                this.nodeToNetworkId.remove(pos);
            }
            this.fowCacheById.remove(pseudoNetworkId);
        }
        LongOpenHashSet nodePositions = new LongOpenHashSet();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(tempNodes.size());
        for (Node.NodeData data : tempNodes) {
            nodePositions.add(data.pos().m_121878_());
            posList.add(data.pos());
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : posList) {
            minX = Math.min(minX, pos.m_123341_());
            minY = Math.min(minY, pos.m_123342_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxX = Math.max(maxX, pos.m_123341_());
            maxY = Math.max(maxY, pos.m_123342_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        BoundingBox bounds = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        NetworkCache pseudoCache = new NetworkCache(pseudoNetworkId, (LongSet)nodePositions, bounds, List.of());
        this.networkCacheById.put(pseudoNetworkId, pseudoCache);
        LongIterator longIterator = nodePositions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            this.nodeToNetworkId.put(pos, (Object)pseudoNetworkId);
        }
        this.getOrComputeFoWCache(pseudoCache);
        ViaRomana.LOGGER.debug("Created/updated pseudonetwork {} with {} nodes", (Object)pseudoNetworkId, (Object)tempNodes.size());
    }

    public void removeNode(Node node) {
        this.removeNode(node.getBlockPos());
    }

    public void removeNode(BlockPos pos) {
        long packedPos = pos.m_121878_();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return;
        }
        Node removedNode = (Node)this.nodes.get(idx);
        this.invalidateNetworksContaining(removedNode);
        LongIterator longIterator = removedNode.getConnectedNodes().iterator();
        while (longIterator.hasNext()) {
            long neighborPos = (Long)longIterator.next();
            this.getNodeAt(BlockPos.m_122022_((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(packedPos));
        }
        this.removeNodeFromSpatialIndex(removedNode);
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        this.dirtyNodePositions.remove(packedPos);
        removedNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
    }

    public void removeBranch(Node startNode) {
        Set<Node> branchNodes = this.findBranchNodes(startNode);
        if (branchNodes.isEmpty()) {
            return;
        }
        this.invalidateNetworksContaining(startNode);
        LongOpenHashSet branchPositions = new LongOpenHashSet();
        for (Node n : branchNodes) {
            branchPositions.add(n.getPos());
        }
        for (Node node : branchNodes) {
            LongIterator longIterator = node.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (branchPositions.contains(neighborPos)) continue;
                this.getNodeAt(BlockPos.m_122022_((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(node.getPos()));
            }
            this.removeNodeWithoutNeighborUpdates(node);
        }
    }

    private void removeNodeWithoutNeighborUpdates(Node node) {
        long packedPos = node.getPos();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return;
        }
        this.removeNodeFromSpatialIndex(node);
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        this.dirtyNodePositions.remove(packedPos);
        node.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
    }

    private void removeNodeFromSpatialIndex(Node node) {
        BlockPos p = node.getBlockPos();
        long chunkPos = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)p.m_123341_()), (int)SectionPos.m_123171_((int)p.m_123343_()));
        List chunkNodes = (List)this.nodesByChunk.get(chunkPos);
        if (chunkNodes != null) {
            chunkNodes.remove(node);
            if (chunkNodes.isEmpty()) {
                this.nodesByChunk.remove(chunkPos);
            }
        }
    }

    public void removeAllNodes() {
        for (NetworkCache cache : this.networkCacheById.values()) {
            try {
                ServerMapCache.invalidate(cache.id());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache during clear for {}: {}", (Object)cache.id(), (Object)e.getMessage());
            }
        }
        this.nodes.clear();
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        this.nodesByChunk.clear();
        this.networkCacheById.clear();
        this.nodeToNetworkId.clear();
        this.fowCacheById.clear();
        this.chunkToNetworkIds.clear();
        this.dirtyNodePositions.clear();
    }

    public void linkSignToNode(BlockPos nodePos, BlockPos signPos, Node.LinkType linkType, UUID owner) {
        this.getNodeAt(nodePos).map(node -> {
            node.setSignPos(signPos.m_121878_());
            node.setLinkType(linkType);
            if (linkType == Node.LinkType.PRIVATE && owner != null) {
                node.setPrivateOwner(owner);
            }
            this.signPosToIndex.put(signPos.m_121878_(), this.posToIndex.get(nodePos.m_121878_()));
            this.refreshNetworkDestinations((Node)node);
            return true;
        });
    }

    public void removeSignLink(BlockPos signPos) {
        this.getNodeBySignPos(signPos).map(node -> {
            node.unlink();
            this.signPosToIndex.remove(signPos.m_121878_());
            if (CommonConfig.logging_enum.ordinal() > 0) {
                ViaRomana.LOGGER.info("Successfully unlinked sign at {}", (Object)signPos);
            }
            this.refreshNetworkDestinations((Node)node);
            return true;
        });
    }

    public Optional<Node> getNodeBySignPos(BlockPos signPos) {
        int idx = this.signPosToIndex.getOrDefault(signPos.m_121878_(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public Optional<Node> getNearestNode(BlockPos origin, double maxDistance) {
        return this.getNearestNode(origin, maxDistance, maxDistance, node -> true);
    }

    public Optional<Node> getNearestNode(BlockPos origin, double maxDistance, Predicate<Node> filter) {
        return this.getNearestNode(origin, maxDistance, maxDistance, filter);
    }

    public Optional<Node> getNearestNode(BlockPos origin, double maxDistance, double maxYDistance, Predicate<Node> filter) {
        int originX = origin.m_123341_();
        int originY = origin.m_123342_();
        int originZ = origin.m_123343_();
        double minDistanceSq = maxDistance * maxDistance;
        int chunkRadius = (int)Math.ceil(maxDistance / 16.0);
        int centerChunkX = SectionPos.m_123171_((int)originX);
        int centerChunkZ = SectionPos.m_123171_((int)originZ);
        Node bestNode = null;
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                int absChunkX = centerChunkX + x;
                int absChunkZ = centerChunkZ + z;
                long chunkKey = ChunkPos.m_45589_((int)absChunkX, (int)absChunkZ);
                List chunkNodes = (List)this.nodesByChunk.get(chunkKey);
                if (chunkNodes == null || chunkNodes.isEmpty()) continue;
                int chunkMinX = absChunkX << 4;
                int chunkMinZ = absChunkZ << 4;
                int chunkMaxX = chunkMinX + 15;
                int chunkMaxZ = chunkMinZ + 15;
                double dX = 0.0;
                if (originX < chunkMinX) {
                    dX = chunkMinX - originX;
                } else if (originX > chunkMaxX) {
                    dX = originX - chunkMaxX;
                }
                double dZ = 0.0;
                if (originZ < chunkMinZ) {
                    dZ = chunkMinZ - originZ;
                } else if (originZ > chunkMaxZ) {
                    dZ = originZ - chunkMaxZ;
                }
                if (dX * dX + dZ * dZ > minDistanceSq) continue;
                for (Node node : chunkNodes) {
                    BlockPos nodePos;
                    int dy;
                    if (!filter.test(node) || (double)(dy = Math.abs((nodePos = node.getBlockPos()).m_123342_() - originY)) > maxYDistance) continue;
                    double dXCentered = (double)nodePos.m_123341_() + 0.5 - ((double)originX + 0.5);
                    double dZCentered = (double)nodePos.m_123343_() + 0.5 - ((double)originZ + 0.5);
                    double dYCentered = (double)nodePos.m_123342_() + 0.5 - ((double)originY + 0.5);
                    double distSq = dXCentered * dXCentered + dYCentered * dYCentered + dZCentered * dZCentered;
                    if (!(distSq <= minDistanceSq)) continue;
                    minDistanceSq = distSq;
                    bestNode = node;
                }
            }
        }
        return Optional.ofNullable(bestNode);
    }

    public List<Node> getNetwork(Node start) {
        ArrayList<Node> network = new ArrayList<Node>();
        LongOpenHashSet visited = new LongOpenHashSet();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        visited.add(start.getPos());
        queue.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            network.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (!visited.add(neighborPos)) continue;
                this.getNodeAt(BlockPos.m_122022_((long)neighborPos)).ifPresent(queue::add);
            }
        }
        return network;
    }

    private Set<Node> findBranchNodes(Node start) {
        HashSet<Node> branch = new HashSet<Node>();
        if (start.getConnectedNodes().size() >= 3) {
            branch.add(start);
            return branch;
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        HashSet<Node> visited = new HashSet<Node>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            branch.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                this.getNodeAt(BlockPos.m_122022_((long)neighborPos)).ifPresent(neighbor -> {
                    if (visited.add((Node)neighbor) && neighbor.getConnectedNodes().size() < 3) {
                        queue.add((Node)neighbor);
                    }
                });
            }
        }
        return branch;
    }

    public List<Node> getCachedTeleportDestinationsFor(UUID playerId, Node sourceNode) {
        NetworkCache cache = this.getNetworkCacheForNode(sourceNode);
        return cache.destinationNodes().stream().filter(node -> node.getPos() != sourceNode.getPos()).filter(node -> node.isAccessibleBy(playerId)).toList();
    }

    private BoundingBox calculateBoundsFor(List<Node> networkNodes) {
        if (networkNodes.isEmpty()) {
            return BoundingBox.ZERO;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Node node : networkNodes) {
            BlockPos pos = node.getBlockPos();
            minX = Math.min(minX, pos.m_123341_());
            minY = Math.min(minY, pos.m_123342_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxX = Math.max(maxX, pos.m_123341_());
            maxY = Math.max(maxY, pos.m_123342_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public NetworkCache getNetworkCache(UUID id) {
        return this.networkCacheById.get(id);
    }

    public NetworkCache getNetworkCache(Node startNode) {
        return this.getNetworkCacheForNode(startNode);
    }

    public List<NetworkCache> findNetworksForChunk(ChunkPos chunkPos) {
        this.processDirtyNodes();
        Set networkIds = (Set)this.chunkToNetworkIds.get(chunkPos.m_45588_());
        if (networkIds == null || networkIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NetworkCache> result = new ArrayList<NetworkCache>(networkIds.size());
        for (UUID uuid : networkIds) {
            NetworkCache cache = this.networkCacheById.get(uuid);
            if (cache == null) continue;
            result.add(cache);
        }
        return result;
    }

    private void processDirtyNodes() {
        if (this.dirtyNodePositions.isEmpty()) {
            return;
        }
        long[] toProcess = this.dirtyNodePositions.toLongArray();
        this.dirtyNodePositions.clear();
        for (long pos : toProcess) {
            int idx;
            if (this.nodeToNetworkId.containsKey(pos) || (idx = this.posToIndex.getOrDefault(pos, -1)) == -1) continue;
            Node node = (Node)this.nodes.get(idx);
            this.discoverAndCacheNetwork(node);
        }
    }

    public FoWCache getOrComputeFoWCache(NetworkCache network) {
        boolean isPseudo = ServerMapCache.isPseudoNetwork(network.id());
        return this.fowCacheById.computeIfAbsent(network.id(), id -> {
            FoWCache fow = PathGraph.calculateFoWData(network.nodePositions(), isPseudo);
            if (fow != null) {
                this.addNetworkToChunkMap((UUID)id, fow);
            }
            return fow;
        });
    }

    private void addNetworkToChunkMap(UUID networkId, FoWCache fow) {
        for (ChunkPos chunk : fow.allowedChunks()) {
            ((Set)this.chunkToNetworkIds.computeIfAbsent(chunk.m_45588_(), c -> new HashSet())).add(networkId);
        }
    }

    private void removeNetworkFromChunkMap(UUID networkId, FoWCache fow) {
        for (ChunkPos chunk : fow.allowedChunks()) {
            Set ids = (Set)this.chunkToNetworkIds.get(chunk.m_45588_());
            if (ids == null) continue;
            ids.remove(networkId);
            if (!ids.isEmpty()) continue;
            this.chunkToNetworkIds.remove(chunk.m_45588_());
        }
    }

    public static FoWCache calculateFoWData(LongSet nodeLongs, boolean isPseudo) {
        if (nodeLongs.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        LongIterator it = nodeLongs.iterator();
        while (it.hasNext()) {
            long nodeLong = it.nextLong();
            int x = BlockPos.m_121983_((long)nodeLong);
            int y = BlockPos.m_122008_((long)nodeLong);
            int z = BlockPos.m_122015_((long)nodeLong);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        int cacheWidth = maxX - minX;
        int cacheHeight = maxZ - minZ;
        int padding = ServerMapUtils.calculateUniformPadding(cacheWidth, cacheHeight);
        BlockPos paddedMin = new BlockPos(minX - padding, minY, minZ - padding);
        BlockPos paddedMax = new BlockPos(maxX + padding, maxY, maxZ + padding);
        ChunkPos minChunk = new ChunkPos(paddedMin);
        ChunkPos maxChunk = new ChunkPos(paddedMax);
        Set<ChunkPos> allowedChunks = ServerMapUtils.calculateFogOfWarChunks((Set<Long>)nodeLongs, minChunk, maxChunk, isPseudo);
        return new FoWCache(minChunk, maxChunk, paddedMin, paddedMax, allowedChunks);
    }

    public List<Node> queryNearby(BlockPos center, double radius) {
        double radiusSquared = radius * radius;
        ArrayList<Node> results = new ArrayList<Node>();
        int chunkRadius = (int)Math.ceil(radius / 16.0);
        int centerChunkX = SectionPos.m_123171_((int)center.m_123341_());
        int centerChunkZ = SectionPos.m_123171_((int)center.m_123343_());
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                long chunkKey = ChunkPos.m_45589_((int)(centerChunkX + x), (int)(centerChunkZ + z));
                List chunkNodes = (List)this.nodesByChunk.get(chunkKey);
                if (chunkNodes == null) continue;
                for (Node node : chunkNodes) {
                    if (!(node.getBlockPos().m_123331_((Vec3i)center) <= radiusSquared)) continue;
                    results.add(node);
                }
            }
        }
        return results;
    }

    public CompoundTag serialize(CompoundTag root) {
        ListTag list = new ListTag();
        for (Node node : this.nodes) {
            list.add((Object)node.serialize(new CompoundTag()));
        }
        root.m_128365_("nodes", (Tag)list);
        return root;
    }

    public void deserialize(CompoundTag root) {
        this.removeAllNodes();
        ListTag list = root.m_128437_("nodes", 10);
        for (Tag raw : list) {
            CompoundTag nodeTag = (CompoundTag)raw;
            long pos = nodeTag.m_128454_("pos");
            if (pos == BlockPos.f_121853_.m_121878_()) continue;
            this.nodes.add((Object)new Node(nodeTag));
        }
        this.rebuildIndices();
    }

    public void rebuildIndices() {
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        this.dirtyNodePositions.clear();
        this.chunkToNetworkIds.clear();
        this.nodesByChunk.clear();
        int i = 0;
        while (i < this.nodes.size()) {
            Node node = (Node)this.nodes.get(i);
            this.posToIndex.put(node.getPos(), i);
            int finalI = i++;
            node.getSignPos().ifPresent(sp -> this.signPosToIndex.put(sp.longValue(), finalI));
            this.dirtyNodePositions.add(node.getPos());
            long chunkPos = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)node.getBlockPos().m_123341_()), (int)SectionPos.m_123171_((int)node.getBlockPos().m_123343_()));
            ((List)this.nodesByChunk.computeIfAbsent(chunkPos, k -> new ArrayList())).add(node);
        }
    }

    public List<DestinationResponseS2C.NodeNetworkInfo> getNodesAsInfo(NetworkCache cache) {
        return cache.getNodesAsInfo(this.posToIndex, this.nodes);
    }

    public List<DestinationResponseS2C.DestinationInfo> getNodesAsDestinationInfo(List<Node> nodes, BlockPos origin) {
        return nodes.stream().map(dest -> {
            double distance = Math.sqrt(origin.m_123331_((Vec3i)dest.getBlockPos()));
            return new DestinationResponseS2C.DestinationInfo(dest.getBlockPos(), dest.getDestinationName().orElse("Unknown"), distance, dest.getDestinationIcon().orElse(Node.Icon.SIGNPOST));
        }).toList();
    }

    public record NetworkCache(UUID id, LongSet nodePositions, BoundingBox bounds, List<Node> destinationNodes) {
        public NetworkCache {
            if (nodePositions != null) {
                nodePositions = LongSets.unmodifiable((LongSet)nodePositions);
            }
        }

        public List<DestinationResponseS2C.NodeNetworkInfo> getNodesAsInfo(Long2IntOpenHashMap posToIndex, ObjectArrayList<Node> allNodes) {
            ArrayList<DestinationResponseS2C.NodeNetworkInfo> list = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(this.nodePositions.size());
            LongIterator it = this.nodePositions.iterator();
            while (it.hasNext()) {
                long pos = it.nextLong();
                int index = posToIndex.getOrDefault(pos, -1);
                if (index != -1) {
                    Node node = (Node)allNodes.get(index);
                    ArrayList<BlockPos> connections = new ArrayList<BlockPos>(node.getConnectedNodes().size());
                    LongIterator longIterator = node.getConnectedNodes().iterator();
                    while (longIterator.hasNext()) {
                        long conn = (Long)longIterator.next();
                        connections.add(BlockPos.m_122022_((long)conn));
                    }
                    list.add(new DestinationResponseS2C.NodeNetworkInfo(BlockPos.m_122022_((long)pos), node.getClearance(), connections));
                    continue;
                }
                list.add(new DestinationResponseS2C.NodeNetworkInfo(BlockPos.m_122022_((long)pos), 0.0f, Collections.emptyList()));
            }
            return list;
        }
    }

    public record BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        public static final BoundingBox ZERO = new BoundingBox(0, 0, 0, 0, 0, 0);
    }

    public record FoWCache(ChunkPos minChunk, ChunkPos maxChunk, BlockPos minBlock, BlockPos maxBlock, Set<ChunkPos> allowedChunks) {
    }
}

