/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.DataInit;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.storage.player.PlayerTrackedData;

public record SyncPlayerDataC2S(int playerId, ResourceLocation keyId, CompoundTag dataTag) implements AbstractPacket
{
    public SyncPlayerDataC2S(int playerId, ResourceLocation keyId, CompoundTag dataTag) {
        this.playerId = playerId;
        this.keyId = keyId;
        this.dataTag = dataTag != null ? dataTag.m_6426_() : new CompoundTag();
    }

    public SyncPlayerDataC2S(TrackedDataKey<?> key, Player player, CompoundTag dataTag) {
        this(player.m_19879_(), key.getId(), dataTag);
    }

    public SyncPlayerDataC2S(FriendlyByteBuf buf) {
        this(buf.m_130242_(), buf.m_130281_(), buf.m_130260_());
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.playerId);
        buf.m_130085_(this.keyId);
        buf.m_130079_(this.dataTag);
    }

    public void handle(Level level, Player player) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.m_19879_() != this.playerId) {
                ViaRomana.LOGGER.warn("Invalid player ID in sync packet from {}", (Object)serverPlayer.m_7755_().getString());
                return;
            }
            if (DataInit.PLAYER_DATA_KEY == null) {
                ViaRomana.LOGGER.warn("Unknown TrackedData key {} in sync packet from {}", (Object)this.keyId, (Object)serverPlayer.m_7755_().getString());
                return;
            }
            TrackedDataContainer container = TrackedDataRegistries.ENTITY.getContainer((Object)serverPlayer);
            if (container == null) {
                ViaRomana.LOGGER.warn("No data container for player {} on sync", (Object)serverPlayer.m_7755_().getString());
                return;
            }
            container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData).ifPresent(data -> {
                try {
                    data.readFromNetwork(this.dataTag);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.error("Failed to apply C2S sync for player {}: {}", (Object)serverPlayer.m_7755_().getString(), (Object)e.getMessage());
                }
            });
        }
    }
}

