/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;

public record SignLinkRequestC2S(LinkHandler.LinkData linkData, boolean isTempNode) implements AbstractPacket
{
    public SignLinkRequestC2S(FriendlyByteBuf buf) {
        this(SignLinkRequestC2S.readLinkData(buf), buf.readBoolean());
    }

    private static LinkHandler.LinkData readLinkData(FriendlyByteBuf buf) {
        BlockPos nodePos = buf.m_130135_();
        BlockPos signPos = buf.m_130135_();
        Node.LinkType linkType = (Node.LinkType)buf.m_130066_(Node.LinkType.class);
        UUID owner = buf.readBoolean() ? buf.m_130259_() : null;
        String destinationName = buf.m_130277_();
        Node.Icon icon = (Node.Icon)buf.m_130066_(Node.Icon.class);
        return new LinkHandler.LinkData(signPos, nodePos, linkType, icon, destinationName, owner);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.linkData.nodePos());
        buf.m_130064_(this.linkData.signPos());
        buf.m_130068_((Enum)this.linkData.linkType());
        buf.writeBoolean(this.linkData.owner() != null);
        if (this.linkData.owner() != null) {
            buf.m_130077_(this.linkData.owner());
        }
        buf.m_130070_(this.linkData.destinationName());
        buf.m_130068_((Enum)this.linkData.icon());
        buf.writeBoolean(this.isTempNode);
    }

    public void handle(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean success = LinkHandler.linkSignToNode(serverLevel, this.linkData);
                if (!success) {
                    ViaRomana.LOGGER.warn("Failed to link sign at {} to node at {} for player {}", (Object)this.linkData.signPos(), (Object)this.linkData.nodePos(), (Object)serverPlayer.m_7755_().getString());
                } else if (CommonConfig.logging_enum.ordinal() > 0) {
                    ViaRomana.LOGGER.info("Successfully linked sign at {} to node at {} for player {}", (Object)this.linkData.signPos(), (Object)this.linkData.nodePos(), (Object)serverPlayer.m_7755_().getString());
                }
            }
        }
    }
}

