/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record PathGraphSyncPacket(CompoundTag pathGraphData, ResourceKey<Level> dimension) implements AbstractPacket
{
    public PathGraphSyncPacket(PathGraph graph, ResourceKey<Level> dimension) {
        this(graph.serialize(new CompoundTag()), dimension);
    }

    public PathGraphSyncPacket(FriendlyByteBuf buf) {
        this(buf.m_130260_(), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)VersionUtils.getLocation(buf.m_130277_())));
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130079_(this.pathGraphData);
        buf.m_130070_(this.dimension.m_135782_().toString());
    }

    public void handle(Level level, Player player) {
        if (level.f_46443_) {
            try {
                PathGraph clientGraph = new PathGraph();
                clientGraph.deserialize(this.pathGraphData);
                ClientPathData.getInstance().updatePathData(clientGraph, this.dimension);
                ViaRomana.LOGGER.debug("Client received PathGraph sync for dimension {} with {} nodes", (Object)this.dimension.m_135782_(), (Object)clientGraph.size());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to process PathGraph sync packet on client", (Throwable)e);
            }
        }
    }
}

