/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.client.gui.TeleportMapScreen;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;

public record DestinationResponseS2C(List<DestinationInfo> destinations, BlockPos signPos, BlockPos sourceNodePos, List<NodeNetworkInfo> networkNodes, UUID networkId) implements AbstractPacket
{
    public DestinationResponseS2C(FriendlyByteBuf buf) {
        this(buf.m_236845_(DestinationInfo::new), (BlockPos)buf.m_236868_(b -> b.m_130135_()), (BlockPos)buf.m_236868_(b -> b.m_130135_()), buf.m_236845_(NodeNetworkInfo::new), buf.m_130259_());
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236828_(this.destinations, (b, dest) -> dest.write((FriendlyByteBuf)b));
        buf.m_236821_((Object)this.signPos, (b, pos) -> b.m_130064_(pos));
        buf.m_236821_((Object)this.sourceNodePos, (b, pos) -> b.m_130064_(pos));
        buf.m_236828_(this.networkNodes, (b, node) -> node.write((FriendlyByteBuf)b));
        buf.m_130077_(this.networkId);
    }

    public void handle(Level level, Player player) {
        if (level != null && level.f_46443_) {
            ClientHandler.handleClient(this);
        }
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        private static void handleClient(DestinationResponseS2C response) {
            Minecraft.m_91087_().m_91152_((Screen)new TeleportMapScreen(response));
        }
    }

    public static class NodeNetworkInfo {
        public final BlockPos position;
        public final float clearance;
        public final List<BlockPos> connections;

        public NodeNetworkInfo(BlockPos position, float clearance, List<BlockPos> connections) {
            this.position = position;
            this.clearance = clearance;
            this.connections = connections;
        }

        public NodeNetworkInfo(FriendlyByteBuf buf) {
            this.position = buf.m_130135_();
            this.clearance = buf.readFloat();
            this.connections = buf.m_236845_(b -> b.m_130135_());
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130064_(this.position);
            buf.writeFloat(this.clearance);
            buf.m_236828_(this.connections, (b, pos) -> b.m_130064_(pos));
        }
    }

    public static class DestinationInfo {
        public final BlockPos position;
        public final String name;
        public final double distance;
        public final Node.Icon icon;

        public DestinationInfo(BlockPos position, String name, double distance, Node.Icon icon) {
            this.position = position;
            this.name = name;
            this.distance = distance;
            this.icon = icon;
        }

        public DestinationInfo(FriendlyByteBuf buf) {
            this(buf.m_130135_(), buf.m_130277_(), buf.readDouble(), Node.Icon.valueOf(buf.m_130277_()));
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130064_(this.position);
            buf.m_130070_(this.name);
            buf.writeDouble(this.distance);
            buf.m_130070_(this.icon.name());
        }
    }
}

